<?php
$cvs_version_tracker[]="\$Id: forum.inc 12748 2007-05-26 17:00:01Z Rytis $";  //Generated automatically - do not edit

require_once('../inc/db.inc');
require_once('../inc/db_forum.inc');
require_once('../inc/time.inc');
require_once('../inc/forum_moderators.inc');
require_once('../inc/text_transform.inc');
require_once('../inc/util.inc');
require_once('../inc/forum_pm.inc');

define('AVATAR_WIDTH', 100);
define('AVATAR_HEIGHT',100);

$special_user_bitfield[0]="Forum moderator";
$special_user_bitfield[1]="Project administrator";
$special_user_bitfield[2]="Project developer";
$special_user_bitfield[3]="Project tester";
$special_user_bitfield[4]="Volunteer developer";
$special_user_bitfield[5]="Volunteer tester";
$special_user_bitfield[6]="Project scientist";

define('ST_NEW_TIME', 1209600); //3600*24*14 - 14 days
define('ST_NEW', 'New member');

define('MAXIMUM_EDIT_TIME',3600); //Maximally allow edits of forums posts up till one hour after posting.

define('FORUM_OPEN_LINK_IN_NEW_WINDOW',1);
define('MAX_FORUM_LOGGING_TIME', 2419200); //3600*24*28 - 28 days
define('NO_CONTROLS', 0);
define('FORUM_CONTROLS', 1);
define('HELPDESK_CONTROLS', 2);
define("EXCERPT_LENGTH", "120");

define('NEW_IMAGE', 'img/unread_post.png');
define('NEW_IMAGE_STICKY', 'img/unread_sticky.png');
define('NEW_IMAGE_LOCKED', 'img/unread_locked.png');
define('NEW_IMAGE_STICKY_LOCKED', 'img/unread_sticky_locked.png');
define('IMAGE_STICKY', 'img/sticky_post.png');
define('IMAGE_LOCKED', 'img/locked_post.png');
define('IMAGE_STICKY_LOCKED', 'img/sticky_locked_post.png');
define('NEW_IMAGE_HEIGHT','15');
define('EMPHASIZE_IMAGE', 'img/emphasized_post.png');
define('EMPHASIZE_IMAGE_HEIGHT','15');
define('FILTER_IMAGE', 'img/filtered_post.png');
define('FILTER_IMAGE_HEIGHT','15');
define('RATE_POSITIVE_IMAGE', 'img/rate_positive.png');
define('RATE_POSITIVE_IMAGE_HEIGHT','9');
define('RATE_NEGATIVE_IMAGE', 'img/rate_negative.png');
define('RATE_NEGATIVE_IMAGE_HEIGHT','9');
define('REPORT_POST_IMAGE', 'img/report_post.png');
define('REPORT_POST_IMAGE_HEIGHT','9');

define ('SOLUTION', 'This answered my question');
define ('SUFFERER', 'I also have this question');
define ('OFF_TOPIC', 'Off-topic');

define ('DEFAULT_LOW_RATING_THRESHOLD', -25);
define ('DEFAULT_HIGH_RATING_THRESHOLD', 5);

$thread_sort_styles['timestamp'] = "Newest first";
$thread_sort_styles['timestamp_asc'] = "Oldest first";
$thread_sort_styles['score'] = "Highest rated first";

$faq_sort_styles['create_time'] = "Most recent question first";
$faq_sort_styles['timestamp'] = "Most recent answer first";
$faq_sort_styles['activity'] = "Most frequently asked first";

$answer_sort_styles['score'] = "Highest score first";
$answer_sort_styles['timestamp'] = "Most recent first";
$answer_sort_styles['timestamp_asc'] = "Oldest first";

$thread_filter_styles['2'] = "\"Very helpful\"";
$thread_filter_styles['1'] = "At least \"helpful\"";
$thread_filter_styles['0'] = "At least \"neutral\"";
$thread_filter_styles['-1'] = "At least \"unhelpful\"";
$thread_filter_styles['-2'] = "All posts";

$post_ratings['2'] = "Very helpful (+2)";
$post_ratings['1'] = "Helpful (+1)";
$post_ratings['0'] = "Neutral";
$post_ratings['-1'] = "Not helpful (-1)";
$post_ratings['-2'] = "Off topic (-2)";

$config = get_config();
$no_forum_rating = parse_bool($config, "no_forum_rating"); 

/**
 *  Process a user-supplied title to remove HTML stuff
 **/
function cleanup_title($title) {
    $x = trim(htmlspecialchars($title));
    $x = stripslashes($x);      // clean up funky old titles in DB
    if (strlen($x)==0) return "(no title)";
    else return $x;
}

/** 
 * Check if user has special user bit enabled
 **/
function isSpecialUser($user, $specialbit){
    return (substr($user->special_user, $specialbit,1)==1);
}

/**
 * Check to see if a specific user has rated a specific post before
 **/
function getHasRated($user, $postid){
    return (strstr($user->rated_posts,"|".$postid));
}

/**
 * Get the user's preferred sorting style.
 **/
function getSortStyle($user,$place){
    if ($user->id!=""){
        list($forum,$thread,$faq,$answer)=explode("|",$user->sorting);
    } else {
        list($forum,$thread,$faq,$answer)=explode("|",$_COOKIE['sorting']);
    }
    return $$place;    // Huh?
}


/*** display functions ***/

/**
 * Show the posts in a thread for a user.
 * It's a big one.
 **/
function show_posts($thread, $sort_style, $filter, $logged_in_user, $show_controls=true) {
    $n = 1;

    if ($show_controls) {
        $controls = FORUM_CONTROLS;
    } else {
        $controls = NO_CONTROLS;
    }

    // If logged in user is moderator,
    // let him see all posts - including hidden ones
    if ($logged_in_user && $logged_in_user->isSpecialUser(S_MODERATOR)){
        $show_hidden_posts = true;
    } else {
        $show_hidden_posts = false;
    }
    $posts = $thread->getPosts($sort_style, $show_hidden_posts);
    $postcount = (sizeof($posts)-1);
    if ($logged_in_user) $last_visit = $thread->getLastReadTimestamp($logged_in_user);

    $postnumber=0; $previous_post=0;
    $no_wraparound = get_str("nowrap",true);
    foreach ($posts as $key => $post){
            $postnumber++;
            
            // There *HAS* to be a better way to do this.  WOW.
            if ((!$logged_in_user) // If the user isn't logged in
                || (!$logged_in_user->getMinimumWrapPostcount()) //or If the user hasn't enabled the feature to display only a certain amount of posts, simply display all of them.
                || ($postcount < $logged_in_user->getMinimumWrapPostcount()) //If it is enabled and we havent yet hit the limit, simply display all
                || ($no_wraparound)  // If the user has asked to display all the posts just display them
                ||
                (
                    ($postcount >= $logged_in_user->getMinimumWrapPostcount()) //If it is enabled and we have hit the limit AND we have the minimum wraparound number of posts or more
                    &&
                    (
                        ($postnumber==1 || $postnumber==($postcount+1)) // Let's display the post only if it is the first post 
                        || 
                        (        
                            (($postnumber > $postcount+1-$logged_in_user->getDisplayWrapPostcount()) //or it is one of the last wrap_display_postcount posts.
                            && ($sort_style==CREATE_TIME_OLD))
                            ||
                            (($postnumber <= $logged_in_user->getDisplayWrapPostcount()) //or it is one of the last wrap_display_postcount posts.
                            && ($sort_style==CREATE_TIME_NEW))
                            || ($sort_style!=CREATE_TIME_NEW && $sort_style!=CREATE_TIME_OLD)
                        )  
                        || ($post->getTimestamp() > $last_visit) //or if this post is unread
                    )
                )
            ) {
                if ($postnumber!=$previous_post+1){
                    //A number of posts were hidden, display a way to unhide them:
                    echo "<tr class=\"postseperator\"><td></td><td colspan=\"2\">
                    Only the first post and the last ".($logged_in_user->getDisplayWrapPostcount())." posts 
                    (of the ".($postcount+1)." posts in this thread) are displayed. <br />
                    <a href=\"?id=".$thread->getID()."&amp;nowrap=true\">Click here to also display the remaining posts</a>.</td></tr>";
                }
                $previous_post=$postnumber;
                show_post($post, $thread, $logged_in_user, $n, $controls, $filter);
                // To allow users to start reading a thread even though our DB layer is super slow
                $n = ($n+1)%2;
                
                if (($post->getTimestamp()>$last_visit) && 
                    ((!$first_unread_post) || ($post->getTimestamp()<$first_unread_post->getTimestamp()))
                   ){
                    $first_unread_post=$post;
                }
            }
    }

    if ($logged_in_user && $logged_in_user->hasJumpToUnread()){
        if ($first_unread_post){
            echo "<script>function jumpToUnread(){location.href='#".$first_unread_post->getID()."';}</script>";
        } else {
            echo "<script>function jumpToUnread(){};</script>";
        }
    }

    if ($logged_in_user) $thread->setLastReadTimestamp($logged_in_user);
}

/**
 * Display an individual post, as though in a thread.
 **/
function show_post($post, $thread, $logged_in_user, $n, $controls=FORUM_CONTROLS, $filter=true) {
    $user = $post->getOwner();
    global $no_forum_rating;
    global $config;

    if ($logged_in_user) {
        $tokens = url_tokens($logged_in_user->getAuthenticator());
    }

    //If the user that made this post is on the list of people to ignore, change thresholds to be much more strict
    if ($logged_in_user){
        if (in_array($user->getID(),$logged_in_user->getIgnoreList())){
            $user_is_on_ignorelist=true;
            $rated_below_threshold = ($logged_in_user->getHighRatingThreshold()>$post->getRating());
            $rated_above_threshold = ($logged_in_user->getHighRatingThreshold()+abs($logged_in_user->getLowRatingThreshold())<($post->getRating()));
        } else {                //Use normal threshold values
            $rated_below_threshold = ($logged_in_user->getLowRatingThreshold()>($post->getRating()));
            $rated_above_threshold = ($logged_in_user->getHighRatingThreshold()<($post->getRating()));
        }
    }
    // The creator can edit the post, but only in a specified amount of time
    // (exception: a moderator can edit his/her posts at any time)
    //
    $can_edit = false;
    if ($logged_in_user) {
        if ($user->getID() == $logged_in_user->getID()) {
            if ($logged_in_user->isSpecialUser(S_MODERATOR)) {
                $can_edit = true;
            } else if (can_reply($thread, $logged_in_user)) {
                $time_limit = $post->getTimestamp()+MAXIMUM_EDIT_TIME;
                $can_edit = time()<$time_limit;
            } else {
                $can_edit = false;
            }
        }
    }

    echo "
        <tr class=\"row$n\" valign=\"top\">
        <td rowspan=\"3\"><div class=\"authorcol\">
        <a name=\"".$post->getID()."\"></a>
    ";

    // Print the user links
    echo re_user_links($user, URL_BASE);
    echo "<br>";

    // Print the special user lines, if any
    global $special_user_bitfield; 
    $fstatus="";
    $keys = array_keys($special_user_bitfield);
    for ($i=0; $i<sizeof($special_user_bitfield);$i++) {
        if ($user->isSpecialUser($keys[$i])) {
            $fstatus.=$special_user_bitfield[$keys[$i]]."<br>";
        }
    }
    if ($user->create_time>time()-ST_NEW_TIME) $fstatus.=ST_NEW."<br>";
    if ($fstatus) echo "<font size=\"-2\">$fstatus</font>";

    echo "<span class=\"authorinfo\">";
    if (!$filter || !$rated_below_threshold){
        if ($user->hasAvatar() && (!$logged_in_user || ($logged_in_user->hasHideAvatars()==false))) {
            echo "<img width=\"".AVATAR_WIDTH."\" height=\"".AVATAR_HEIGHT."\" src=\"".$user->getAvatar()."\" alt=\"Avatar\"><br>";
        }
    }
    
    echo "<a href=\"forum_pm.php?action=new&userid=".$user->getID()."\" class=\"smalltext\">private message</a><br>\n";
    echo "Joined: ", gmdate('M j, Y', $user->getCreateTime()), "<br>";
    
    if(function_exists('project_forum_user_info')){
        project_forum_user_info($user);
    } else { // default
        // circumvent various forms of identity spoofing
        // by displaying the  user id of the poster.
        // its cheap, easy, and doesn't require any additional database calls.
        echo "Posts: ".$user->getPostCount()."<br>";
        echo "ID: ".$user->getID()."<br>";
        echo "Credit: ".number_format($user->getTotalCredit())."<br>";
        echo "RAC: ".number_format($user->getExpavgCredit())."<br>";
    }
    echo "</span></div></td>";

    if ($controls == FORUM_CONTROLS) {
        echo "<form action=\"forum_rate.php?post=", $post->getID(), "\" method=\"post\">";
        echo "<td colspan=\"2\" class=\"postheader\">";
    } else {
        echo "<td class=\"postheader\">";
    }

    if ($logged_in_user && $post->getTimestamp()>$thread->getLastReadTimestamp($logged_in_user)){
        echo "<img src=\"".NEW_IMAGE."\" alt=\"Unread post\" height=\"".NEW_IMAGE_HEIGHT."\">";
    }
    if ($rated_above_threshold){
        echo "<img src=\"".EMPHASIZE_IMAGE."\" alt=\"!\" height=\"".EMPHASIZE_IMAGE_HEIGHT."\">";
    }

    echo " <a href=\"forum_thread.php?id=".$thread->getID()."&nowrap=true#$post->id\">Message ".$post->getID()."</a> - ";
    if ($post->isHidden()) echo "<font color=red>[deleted] </font>";
    echo "
        Posted ", pretty_time_str($post->getTimestamp());
    ;

    if ($post->getParentPostID()) echo " - in response to <a href=\"forum_thread.php?id=".$thread->getID()."&nowrap=true#".$post->getParentPostID()."\">Message ID ".$post->getParentPostID()."</a>.";
    if ($can_edit && $controls != NO_CONTROLS) echo "&nbsp;<a href=\"forum_edit.php?id=".$post->getID()."$tokens\">[Edit this post]</a>";
    if ($logged_in_user && $logged_in_user->isSpecialUser(S_MODERATOR)) echo post_moderation_links($config,$logged_in_user,$post,$tokens); //If user is moderator, show links
    if ($post->getModificationTimestamp()) echo "<br>Last modified: ", pretty_time_Str($post->getModificationTimestamp());
    if ($rated_below_threshold && $filter){
        if ($user_is_on_ignorelist) $andtext=" and the user is on your ignore list";
        echo "<br>This post has been filtered (rating: ".($post->getRating()).")$andtext, press <a href=\"?id=".$thread->getID()."&amp;filter=false#".$post->getID()."\">here</a> to view this thread without filtering";
    }
    echo "</td></tr></form>";
    echo "<tr class=\"row$n\"><td class=\"postbody\" colspan=\"2\">";

    //If either filtering is turned off or this post is not below the threshold
    if (!$filter || !$rated_below_threshold){
        $posttext = $post->getContent();

        // If the creator of this post has a signature and
        // wants it to be shown for this post AND the logged in
        // user has signatures enabled: show it
        //
        if ($post->hasSignature() && (!$logged_in_user || !$logged_in_user->hasHideSignatures())){
            $posttext.="\n____________\n".$user->getSignature();
        }

        if ($logged_in_user){
            $options = $logged_in_user->getTextTransformSettings();
        } else {
            $options = new output_options;
        }
        $posttext = output_transform($posttext,$options);
        
        echo "<p>", $posttext, "</p>";
        echo "</td></tr><tr><td class=\"postfooter\">ID: <i>", $post->id;
        if ($no_forum_rating != NULL) { 
            echo " | <a href=\"forum_report_post.php?post=".$post->getID()."\"><img src=\"".REPORT_POST_IMAGE."\" alt=\"Report this post as offensive\" height=\"".REPORT_POST_IMAGE_HEIGHT."\" border=0></a></td>";
        } else {
        $rating = $post->getRating();
        echo " | Rating: ", $rating, "</i> | rate: <a href=\"forum_rate.php?post=".$post->getID()."&amp;choice=p$tokens\"><img src=\"".RATE_POSITIVE_IMAGE."\" alt=\"+\" height=\"".RATE_POSITIVE_IMAGE_HEIGHT."\" border=0></a> / <a href=\"forum_rate.php?post=".$post->getID()."&amp;choice=n$tokens\"><img src=\"".RATE_NEGATIVE_IMAGE."\" alt=\"-\" height=\"".RATE_NEGATIVE_IMAGE_HEIGHT."\" border=0></a> - <a href=\"forum_report_post.php?post=".$post->getID()."\"><img src=\"".REPORT_POST_IMAGE."\" alt=\"Report this post as offensive\" height=\"".REPORT_POST_IMAGE_HEIGHT."\" border=0></a></td>";
        }
        if (($controls == FORUM_CONTROLS) && (can_reply($thread, $logged_in_user))) {
            echo "<td align=right class=\"postfooter\">[<a href=\"forum_reply.php?thread=" . $thread->getID() . "&amp;post=" . $post->getID() . "#input\">Reply to this post</a>]</td>";
        } else {
            echo "<td class=\"postfooter\"></td>";
        }
        echo "</tr>";
    }
    echo "</td></tr>";
    echo "<tr class=\"postseperator\"><td colspan=3></td></tr>";
}

/*** utility functions ***/

/**
 * Start the forum table, output the proper headings and such.
 **/
function start_forum_table($headings, $extra="width=100%") {
    start_table($extra." cellspacing=0 cellpadding=2");
    echo "<tr>";

    for ($i=0; $i<count($headings); $i++) {
        if (is_array($headings[$i])){
            $title = $headings[$i][0];
            $class = $headings[$i][1]?$headings[$i][1]:"heading";
            if ($headings[$i][2]) $span = " colspan=\"".$headings[$i][2]."\" ";
        } else {
            $title = $headings[$i];
            $class = "heading";
            $span="";
        }
        echo "<th class=$class$span>$title</th>";
    }
    echo "</tr>\n";
}

/**
 * End the forum table, currently just close the open table tag.
 **/
function end_forum_table() {
    echo "</table>\n";
}

/**
 * Output the forum/thread title.
 **/
function show_forum_title($forum=NULL, $thread=NULL, $extended=true) {
    if ($extended) {
        start_table_noborder();
        echo "<tr>\n";
      
        // Search
        echo "<td><form action=\"forum_search_action.php\" method=\"POST\">
            <input type=\"hidden\" name=\"search_max_time\" value=\"30\">
            <input type=\"hidden\" name=\"search_forum\" value=\"-1\">
            <input type=\"hidden\" name=\"search_sort\" value=\"5\">
            <input type=\"text\" name=\"search_keywords\">
            <input type=\"submit\" value=\"search\"><br>
            <span class=\"smalltext\"><a href=\"forum_search.php\">advanced search</a></span>
            </form>
        ";
        echo "</td>\n";
      
        $logged_in_user = get_logged_in_user(false);
        // Custom stuff for logged in user
        if ($logged_in_user) {
            echo "<td align=\"right\">\n";
            
            // Private messages
            echo pm_notification($logged_in_user);
            
            echo "</td>\n";
        }
        echo "</tr>\n";
        end_table();
    }

    echo "<p>\n";
    if ($forum) {
        $category = $forum->getCategory();
        $is_helpdesk = $category->getType();
    } else {
        $is_helpdesk = false;
    }
    $where = $is_helpdesk?tr(LINKS_QA):tr(FORUM_TITLE_SHORT);
    $top_url = $is_helpdesk?"forum_help_desk.php":"forum_index.php";
    if (!$forum && !$thread) {
        echo "<p class=\"title\">";
        echo $where;

    } else if ($forum && !$thread) {
        echo "<span class=title>";
        echo "<a href=\"$top_url\">$where</a> : ";
        echo $forum->getTitle();
        echo "</span><br>";
    } else if ($forum && $thread) {
        echo "<span class=title>";
        echo "<a href=\"$top_url\">$where</a> : ";

        echo "<a href=\"forum_forum.php?id=".$forum->getID()."\">", $forum->getTitle(), "</a> : ";
        echo cleanup_title($thread->getTitle());
        echo "</span><br>";
    } else {
        echo "Invalid input to show_forum_title<br>"; // TODO: handle this condition gracefully 
    }
    echo "</p>\n";
}

/**
 * show a thread with its context (e.g. for search results)
 **/
function show_thread($thread, $n) {
    $forum = getForum($thread->forum);
    $category = getCategory($forum->category);
    $first_post = getFirstPost($thread->id);
    $title = cleanup_title($thread->title);
    $where = $category->is_helpdesk?"Questions and answers":"Message boards";
    $top_url = $category->is_helpdesk?"forum_help_desk.php":"forum_index.php";
    $excerpt = sub_sentence(stripslashes($first_post->content), ' ', EXCERPT_LENGTH, true);
    $posted = time_diff_str($thread->create_time, time());
    $last = time_diff_str($thread->timestamp, time());
    $m = $n%2;
    echo "
        <tr class=\"row$m\">
        <td><font size=\"-2\">
            $n) Posted $posted
            <br>
            Last response $last
        </td>
        <td valign=top>
            <a href=\"$top_url\">$where</a> : $category->name :
            <a href=\"forum_forum.php?id=$forum->id\">$forum->title</a> :
            <a href=\"forum_thread.php?id=$thread->id\">$title</a>
            <br>
            <font size=\"-2\">$excerpt</font>
        </td>
        </tr>
    ";
}

/**
 * Show a post with its context (e.g. for search results)
 **/
function show_post2($post, $n) {
    $thread = getThread($post->thread);
    $forum = getForum($thread->forum);
    $category = getCategory($forum->category);
    $where = $category->is_helpdesk?"Questions and answers":"Message boards";
    $top_url = $category->is_helpdesk?"forum_help_desk.php":"forum_index.php";
    $content = output_transform($post->content);
    $when = time_diff_str($post->timestamp, time());
    $user = lookup_user_id($post->user);
    $title = cleanup_title($thread->title);
    $m = $n%2;
    if($post->hidden) {
        //Todo: factor this array out, it is also used elsewhere
        $deleted_text = array( "Obscene", "Flame/Hate", "Commercial Spam", "Flamebait", "Doublepost", "User Request", "Other");
        $deleted = "<br><font color=red>[Deleted " .
                   "by a moderator " .
                   //as " . $deleted_text[$post->hidden-1] .
                   "] </font>";
    } else {
        $deleted = "";
    }
    echo "
        <tr class=row$m>
        <td>
            $n) <a href=\"$top_url\">$where</a> : $category->name :
            <a href=\"forum_forum.php?id=$forum->id\">$forum->title</a> :
            <a href=\"forum_thread.php?id=$thread->id\">$title</a>
            <br>
            Posted $when by $user->name $deleted
            <hr>
            $content
        </td>
        </tr>
    ";
}


function post_rules() {
    return "
        <ul>
        <li> Posts must be 'kid friendly': they may not contain
            content that is obscene, hate-related,
            sexually explicit or suggestive.
        <li> No commercial advertisements.
        <li> No links to web sites involving sexual content,
            gambling, or intolerance of others.
        <li> No messages intended to annoy or antagonize other people,
            or to hijack a thread.
        <li> No messages that are deliberately hostile or insulting.
        <li> No abusive comments involving race, religion,
            nationality, gender, class or sexuality.
        </ul>
    ";
}

function post_warning() {
    return "<br><br>
        <table><tr><td>
        <font size=-2>
        Rules:
    ".post_rules()."
        <a href=moderation.php>More info</a>
        </font>
        </td></tr></table>
    ";
}

function check_banished($user) {
    $x = $user->getBanishedUntil();
    if ($x>time()) {
        error_page(
            "You may not post or rate messages until ".gmdate('M j, Y', $x)
        );
    }
}

function can_reply($thread, $user) {
    if (!$thread->isLocked() || ($user && $user->isSpecialUser(S_MODERATOR))) {
        return true;
    } else {
        return false;
    }
}

function pm_notification($user) {
    $output = "";
    $pm = mysql_query("SELECT COUNT(*) AS unread FROM private_messages WHERE userid=".$user->id." AND opened=0");
    $pm = mysql_fetch_object($pm);
    if ($pm->unread > 1) {
        $output .= "<strong><a href=\"forum_pm.php?action=inbox\">You have ".$pm->unread." unread private messages.</a> </strong>";
    } elseif ($pm->unread == 1) {
        $output .= "<strong><a href=\"forum_pm.php?action=inbox\">You have one unread private message.</a> </strong>";
    } else {
        $output .= "You have no unread private messages. ";
    }
    
    $output .= "| <a href=\"forum_pm.php?action=inbox\">Inbox</a>\n";
    $output .= "| <a href=\"forum_pm.php?action=new\">Write</a>\n";
    return $output;
}

?>
