//
// cpuid_tbl.cpp - Define different x86 CPUs
//

#include "cpuid_tbl.h"


CPUID_DEFS cpuid_tbl[] = {
	{0,0,0,0,-2,1,"[GenuineIntel]","Intel","Intel Corp."},	// 0,0,0,0 = New Vendor
	{4,0,-1,-1,-2,-1,"486 DX-25/33","486",""},
	{4,1,-1,-1,-2,-1,"486 DX-50","486",""},
	{4,2,-1,-1,-2,-1,"486 SX","486",""},
	{4,3,-1,-1,-2,-1,"486 DX/2","486",""},
	{4,4,-1,-1,-2,-1,"486 SL","486",""},
	{4,5,-1,-1,-2,-1,"486 SX/2","486",""},
	{4,7,-1,-1,-2,-1,"486 DX/2E","486",""},
	{4,8,-1,-1,-2,-1,"486 DX/2E","486",""},
	{4,9,-1,-1,-2,-1,"486 DX/4","486",""},
	{5,0,-1,-1,-2,-1,"Pentium","P1","66a"},
	{5,1,-1,-1,-2,-1,"Pentium","P1","66a"},
	{5,2,-1,-1,-2,-1,"Pentium","P1","75"},
	{5,3,-1,-1,-2,-1,"Pentium","P1","OverDrive"},
	{5,4,-1,-1,-2,-1,"Pentium-MMX","P1",""},
	{5,7,-1,-1,-2,-1,"Pentium-I-M","Pmmx",""},
	{5,8,-1,-1,-2,-1,"Pentium-MMX-M","Pmmx",""},
	{6,0,-1,-1,-2,-1,"Pentium-Pro","Ppro","A-step"},
	{6,1,-1,-1,-2,-1,"Pentium-Pro","Ppro",""},
	{6,3,-1,-1,-2,-1,"Pentium-II","P2","(Klamath)"},
	{6,5,-1,-1,-2,-1,"Pentium-II","P2","(Deschutes)"},
	{6,5,-1,-1,-2, 16,"P2 Celeron","P2c",""},
	{6,5,-1,-1,-2,256,"Pentium-II","P2",""},
	{6,6,-1,-1,-2, 16,"P2 Celeron","P2c","(Mendocino)"},
	{6,6,-1,-1,-2,256,"Pentium-II","P2c","(Mendocino)"},
	
	{6,7,-1,-1,-2, 16,"P3 Celeron","P3c","(Katmai)"},
	{6,7,-1,-1,-2,512,"Pentium-III","P3","(Katmai)"},
	{6,8,-1,-1,0x1,-1,"P3 Celeron","P3c","(Coppermine)"},
	{6,8,-1,-1,0x2,-1,"Pentium-III","P3","(Coppermine)"},
	{6,8,-1,-1,0x3,-1,"Pentium-III Xeon","P3-x","(Coppermine)"},
	{6,9,-1,-1,0x3,-1,"P3 Celeron","P3c",""},
	{6,9,-1,-1,0x4,-1,"Pentium-III","P3",""},
	{6,9,-1,-1,0x6,-1,"Pentium-III (mobile)","P3c",""},
	{6,9,-1,-1,0x7,-1,"P3 Celeron (mobile)","P3cM",""},

	{6,10,-1,-1,-2,  16,"P3 Celeron","P3c",""}, 
	{6,10,-1,-1,-2,4096,"Pentium-III","P3",""},  
	{6,11,-1,-1,0x3,-1,"P3 Celeron","P3c",""},
	{6,11,-1,-1,0x4,-1,"Pentium-III","P3",""},
	{6,11,-1,-1,0x6,-1,"Pentium-III (mobile)","P3c",""},
	{6,11,-1,-1,0x7,-1,"P3 Celeron (mobile)","P3cM",""},
	{6,13,-1,-1,-2,-1,"Pentium M","PM",""},
	{7,0, 0,-1,-2,-1,"Itanium","IA64","(Merced)"},
	{7,0, 1,-1,-2,-1,"Itanium-II","IA64-2","(McKinley)"},
	{7,1, 1,-1,-2,-1,"Itanium-II","IA64-2","(Madison)"},
	{7,2, 1,-1,-2,-1,"Itanium-II","IA64-2","(Madison 9M)"},

	{7,99, 1,-1,-2,-1,"Itanium-II Plus","IA64+","(Unknown)"},
	{7,99,99,-1,-2,-1,"Itanium-?? Plus","IA64+","(Unknown)"},

	{15,1,-1,-1,0x08,-1,"Pentium-IV","P4","(Willamette)"},
	{15,1,-1,-1,0x0A,-1,"P4 Celeron","P4","(Willamette)"},
	{15,1,-1,-1,0x0B,-1,"Pentium-IV Xeon MP","P4","(Willamette)"},
	{15,1,-1,-1,0x0E,-1,"Pentium-IV Xeon","P4","(Willamette)"},
	{15,1,-1,-1,  -1,-1,"Pentium-IV","P4",""},

	{15,2,-1,-1,0x09,-1,"Pentium-IV","P4",""},
	{15,2,-1,-1,0x0B,-1,"Pentium-IV Xeon","P4",""},
	{15,2,-1,-1,0x0C,-1,"Pentium-IV Xeon MP","P4",""},
	{15,2,-1,-1,0x0E,-1,"Pentium-IV (mobile)","P4",""},
	{15,2,-1,-1,0x0F,-1,"P4 Celeron (mobile)","P4",""},
	{15,2,-1,-1,0x12,-1,"P4 Celeron M","P4",""},
	{15,2,-1,-1,0x16,-1,"Pentium M","P4",""},
	{15,2,-1,-1,  -1,-1,"Pentium-IV","P4",""},

	{15,3,-1,-1,0x12,-1,"P4 Celeron M","P4",""},
	{15,3,-1,-1,0x13,-1,"Pentium-IV (mobile)","P4",""},
	{15,3,-1,-1,0x14,-1,"P4 Celeron M","P4",""},
	{15,3,-1,-1,0x16,-1,"Pentium M","P4",""},
	{15,3,-1,-1,  -1,-1,"Pentium-IV","P4",""},

	{16,0,-1,-1,  -1,-1,"Pentium-IV Plus","P4+",""},

// AMD
	{0,0,0,0,-2,2,"[AMD ISBETTER]","AMD","Advanced Micro Devices"},
	{0,0,0,0,-2,2,"[AuthenticAMD]","AMD","Advanced Micro Devices"},
	{4,3,-1,-1,-2,-1,"486 DX/2","486",""},
	{4,7,-1,-1,-2,-1,"486 DX/2","486",""},
	{4,8,-1,-1,-2,-1,"486 DX/4","486",""},
	{4,9,-1,-1,-2,-1,"486 DX/4","486",""},
	{4,14,-1,-1,-2,-1,"Am5x86","5x86",""},
	{4,15,-1,-1,-2,-1,"Am5x86","5x86","SSA5"},
	{5,0,-1,-1,-2,-1,"K5","K5",""},
	{5,1,-1,-1,-2,-1,"K5","K5",""},
	{5,2,-1,-1,-2,-1,"K5","K5",""},
	{5,3,-1,-1,-2,-1,"K5","K5",""},
	{5,6,-1,-1,-2,-1,"K6","K6",""},
	{5,7,-1,-1,-2,-1,"K6","K6",""},
	{5,8,-1,-1,-2,-1,"K6-2","K6-2",""},
	{5,9,-1,-1,-2,-1,"K6-III","K6-3","Sharptooth"},
	{5,13,-1,-1,-2,-1,"K6-2+","K6-3+","Sharptooth"},
	{6,0,-1,-1,-2,-1,"Athlon","K7",""},
	{6,1,-1,-1,-2,-1,"Athlon","K7",""},
	{6,2,-1,-1,-2,-1,"Athlon","K7",""},
	{6,3,-1,-1,-2,-1,"Duron","K7","(mobile)"},
	{6,4,-1,-1,-2,-1,"Athlon","K7","Thunderbird"},
	{6,5,-1,-1,-2,-1,"Athlon","K7",""},
		//With model >=6, If the L2 cache size reported is less than 256, then the processor is an AMD Duron family processor
		//MP if multiprocessor bit is set
	{6,6,-1,-1,-2,256,"Athlon XP","K7-XP","Palomino"},
	{6,6,-1,-1,-2,16,"Duron XP","K7-XP","Palomino"},
	{6,7,-1,-1,-2,256,"Athlon M","K7","Morgan"},
	{6,7,-1,-1,-2,16,"Duron M","K7","Morgan"},
	{6,8,-1,-1,-2,256,"Athlon XP","K7-XP","Thoroughbred"},
	{6,8,-1,-1,-2,16,"Duron XP","K7-XP","Thoroughbred"},
	{6,9,-1,-1,-2,256,"Athlon XP","K7-XP","Thoroughbred"},
	{6,9,-1,-1,-2,16,"Duron XP","K7-XP","Thoroughbred"},
	{6,10,-1,-1,-2,256,"Athlon XP","K7","Barton"},
	{6,10,-1,-1,-2,16,"Duron XP","K7","Barton"},

	{6,99,-1,-1,-2,16,"Athlon XP plus","K7+","(Unknown)"},

	{15,99,0,4,-2,-1,"Athlon-64","K8",""},
	{15,99,0,5,-2,-1,"Athlon-64 FX","K8","(Opteron)"},
	{15,99,0,15,-2,-1,"Athlon-64","K8",""},

	{15,99,0,99,-2,-1,"Athlon-64 plus","K8+","(Unknown)"},


	{0,0,0,0,-2,3,"[CyrixInstead]","Cyrix","Cyrix Corp. / VIA Inc."},
	{4,4,-1,-1,-2,-1,"MediaGX","MedGx",""},
		// CPU feature flags. The 6x86L supports the "compare and exchange 8-byte
	{5,2,-1,-1,-2,-1,"6x86/6x86L","6x86L",""},
	{5,4,-1,-1,-2,-1,"MediaGX","GxMmx","MMX enhanced"},
	{6,0,-1,-1,-2,-1,"6x86MX","6x86MX",""},
	{6,5,-1,-1,-2,-1,"VIA-Cyrix","M2","M2 core"},
	{6,6,-1,-1,-2,-1,"WinChip-C5a","C5A","C5A"},
	{6,7,-1,-1,-2,-1,"WinChip-C5b","C5C","C5C"},
	{6,8,-1,-1,-2,-1,"WinChip-C5n","C5N","C5N"},
	{6,9,-1,-1,-2,-1,"WinChip-C5XL","C5P","C5P"},
	
	{0,0,0,0,-2,4,"[UMC UMC UMC ]","UMC","United Microelectronics Corp."},
	{4,1,-1,-1,-2,-1,"U5D","U5D",""},
	{2,99,-1,-1,-2,-1,"U5S","U5S",""},
	
	{0,0,0,0,-2,5,"[NexGenDriven]","Nexgen","NexGen Inc."},
	{5,0,-1,-1,-2,-1,"Nx586","Nx586",""},
	
	{0,0,0,0,-2,6,"[RiseRiseRise]","Rise","Rise"},
	{5,0,-1,-1,-2,-1,"mP6","mP6",""},
	
	{0,0,0,0,-2,7,"[SiS SiS SiS ]","",""},
	{5,0,-1,-1,-2,-1,"55x","55x",""},

	{0,0,0,0,-2,8,"[TransmetaCPU]","TMT","Transmeta"},
	{0,0,0,0,-2,8,"[GenuineTMx86]","TMT","Transmeta"},
	{5,4,-1,-1,-2,-1,"Crusoe","Crusoe","TM3x00"},

	{0,0,0,0,-2,8,"[CentaurHauls]","IDT","IDT or VIA"},
	{5,4,-1,-1,-2,-1,"C6","C6",""},
	{8,99,-1,-1,-2,-1,"C2","C2",""},
	{9,99,-1,-1,-2,-1,"C3","C3",""},


	{0,0,0,0,-2,9,"[Geode by NSC]","NSC","National Semiconductor "},
	{5,4,-1,-1,-2,-1,"GX1","GX1","GXLV"},
	{5,5,-1,-1,-2,-1,"GX2","GX2",""},

	{0,0,0,0,-2,-1,"","",""},	// Terminator
	};

AMD_PERFTBL perfTbl[] = {
	{256, 950,  1100},
	{256, 1000, 1200},
	{256, 1100, 1300},
	{256, 1200, 1400},
	{256, 1300, 1500},
	{256, 1333, 1500},
	{256, 1400, 1600},
	{256, 1467, 1700},
	{256, 1500, 1800},
	{256, 1533, 1800},
	{256, 1600, 1900},
	{256, 1667, 2000},
	{256, 1733, 2100},
	{256, 1800, 2200},
	{256, 2000, 2400},
	{256, 2083, 2600},
	{256, 2133, 2600},
	{256, 2167, 2700},
	{256, 2250, 2800},
	{512, 1300, 1700},
	{512, 1400, 1800},
	{512, 1467, 1900},
	{512, 1533, 2000},
	{512, 1600, 2100},
	{512, 1667, 2200},
	{512, 1800, 2400},
	{512, 1833, 2500},
	{512, 1867, 2500},
	{512, 1917, 2600},
	{512, 2000, 2600},
	{512, 2083, 2800},
	{512, 2100, 3000},
	{512, 2133, 2800},
	{512, 2167, 3000},
	{512, 2200, 3200}
	};

_cacheCodes cacheCodes[] = {
	{0x06,  8, 0,32,   0,   0,   0},
	{0x08, 16, 0,32,   0,   0,   0},
	{0x0A,  0, 8,32,   0,   0,   0},
	{0x0C,  0,16,32,   0,   0,   0},
	{0x10,  0,16,32,   0,   0,   0},
	{0x15,  0,16,32,   0,   0,   0},
	{0x1A,  0,96,96,   0,   0,   0},
	{0x22,  0, 0,64,   0,   0, 512},
	{0x23,  0, 0,64,   0,   0,1024},
	{0x25,  0, 0,64,   0,   0,2048},
	{0x29,  0, 0,64,   0,   0,4096},
	{0x2c,  0,32,64,   0,   0,   0},
	{0x30, 32, 0,64,   0,   0,   0},
	{0x39,  0, 0,64,   0, 128,   0},
	{0x3B,  0, 0,64,   0, 128,   0},
	{0x3C,  0, 0,64,   0, 256,   0},
	{0x41,  0, 0,32,   0, 128,   0},
	{0x42,  0, 0,32,   0, 256,   0},
	{0x43,  0, 0,32,   0, 512,   0},
	{0x44,  0, 0,32,   0,1024,   0},
	{0x45,  0, 0,32,   0,2048,   0},
	{0x50,  4, 0, 0,   0,   0,   0},
	{0x51,  4, 0, 0,   0,   0,   0},
	{0x52,  4, 0, 0,   0,   0,   0},
	{0x5b,  0, 4, 0,   0,   0,   0},
	{0x5c,  0, 4, 0,   0,   0,   0},
	{0x5d,  0, 4, 0,   0,   0,   0},
	{0x60,  0,16, 0,   0,   0,   0},
	{0x66,  0, 8,64,   0,   0,   0},
	{0x67,  0,16,64,   0,   0,   0},
	{0x68,  0,32,64,   0,   0,   0},
	{0x77, 16, 0,64,   0,   0,   0},
	{0x78,  0, 0,64,   0,1024,   0},
	{0x79,  0, 0,64,   0, 128,   0},
	{0x7a,  0, 0,64,   0, 256,   0},
	{0x7b,  0, 0,64,   0, 512,   0},
	{0x7c,  0, 0,64,   0,1024,   0},
	{0x7d,  0, 0,64,   0,2048,   0},
	{0x7e,  0, 0,64,   0, 256,   0},
	{0x7f,  0, 0,64,   0, 512,   0},
	{0x80,  0, 0,16,   0, 128,   0},
	{0x81,  0, 0,32,   0, 128,   0},
	{0x82,  0, 0,32,   0, 256,   0},
	{0x83,  0, 0,32,   0, 512,   0},
	{0x84,  0, 0,32,   0,1024,   0},
	{0x85,  0, 0,32,   0,2048,   0},
	{0x86,  0, 0,64,   0, 512,   0},
	{0x87,  0, 0,32,   0,1024,   0},
	{0x88,  0, 0,64,   0,   0,2048},	// IA-64 Only
	{0x89,  0, 0,64,   0,   0,4096},
	{0x8a,  0, 0,64,   0,   0,8192},
	{0x8d,  0, 0,128,  0,   0,4096},

	{0xFF,  0, 0, 0,   0,   0,   0}
	};

const char *BOINC_RCSID_92b1369deb = "$Id: cpuid_tbl.cpp,v 1.3 2005/01/02 18:29:16 ballen Exp $";
