/* $Id: bomb.h,v 1.1 2004/04/03 14:48:42 stpohle Exp $
 * bomb include file
 */

#ifndef _BOMB_H_
#define _BOMB_H_


enum _bombstate {
    BS_off = 0,
    BS_ticking,
    BS_exploding,
	BS_trigger
};


enum _bombmode {
	BM_normal = 0,
	BM_pushed,
	BM_moving,
	BM_liquid,
	BM_kicked
};


struct {
    _pointf pos;				// lower byte = _X Higher Byte = FX
	struct __bomb_id {			// save the bomb id
		signed char p;			// playernumber of this bomb
		signed char b;			// bombnumber of this bomb
	} id;
    int firer[4];               // range of the fire for the fire for each direction
    int firerst[4];             /* just save here where the direction was going to stop (-1) 
								if the exp is still growing */
    float to;                     // timeout in ms after dropping the bomb. (loops * 0.0005sec)
    float frame;                  // frame of the animation
    unsigned char r;            // range of the bomb
    unsigned char state;        // state of the bomb BS_*
	unsigned char mode;			// mode of the bomb BM_*
    int ex_nr;                  // explosion number
	_point dest;				// destination to move the bomb to
	float speed;				// bomb moving speed
} typedef _bomb;



// for the bomb..
extern int bomb_loop ();
extern void bomb_explode (_bomb *bomb, int net);
extern inline void bomb_action (_bomb *bomb);
extern void bomb_move (_bomb *bomb);
extern void get_bomb_on (float x, float y, _point bombs[]);
extern void do_explosion (_bomb *bomb);
extern void restore_explosion (_bomb * bomb);
extern int explosion_check_field (int x, int y, _bomb *bomb);


#endif
