/* $Id: gfx.c,v 1.35 2004/05/20 16:55:30 stpohle Exp $ */
/* gfx.c */

#include "bomberclone.h"
#include "menu.h"

_gfx gfx;

#define __smalsizeX 12
void
gfx_load_players (int sx, int sy)
{
    float sfkt,
      ssfkt;
    char filename[255];
    int i,
      j,
      r,
      g,
      b;
    SDL_Surface *tmpimage,
     *tmpimage1;
    sfkt = ((float) sx) / ((float) GFX_IMGSIZE);
    ssfkt = ((float) __smalsizeX) / ((float) GFX_IMGSIZE);

    /* loading the player images */
    for (j = i = 0; i < MAX_PLAYERS; i++) {
        sprintf (filename, "%s/player/player%d.png", bman.datapath, j);
        j++;
        tmpimage = IMG_Load (filename);
        if (tmpimage == NULL) {
            if (j == 0) {       // try again with the first image, if this don't work give up.
                printf ("Can't load image: %s\n", SDL_GetError ());
                exit (1);
            }
            i--;                // load the this image again
            j = 0;
        }

        else {

            /* load the game player image */
            gfx.players[i].ani.h = sy * 2;
            gfx.players[i].ani.w = (tmpimage->w / 4) * sfkt;
            gfx.players[i].ani.frames = tmpimage->h / GFX_PLAYERIMGSIZE_Y;
            tmpimage1 =
                scale_image (tmpimage, gfx.players[i].ani.w * 4,
                             gfx.players[i].ani.frames * gfx.players[i].ani.h);
            getRGBpixel (tmpimage1, 0, 0, &r, &g, &b);
            SDL_SetColorKey (tmpimage1, SDL_SRCCOLORKEY, SDL_MapRGB (tmpimage1->format, r, g, b));
            gfx.players[i].ani.image = SDL_DisplayFormat (tmpimage1);
            SDL_FreeSurface (tmpimage1);

            /* calculate the numbers of images for the animation */
            gfx.players[i].offset.x = (sx - gfx.players[i].ani.w) / 2;
            gfx.players[i].offset.y = -sy;

            /* load the smal image */
            gfx.players[i].smal_size.y = __smalsizeX * 2;
            gfx.players[i].smal_size.x = (tmpimage->w / 4) * ssfkt;
            tmpimage1 =
                scale_image (tmpimage, gfx.players[i].smal_size.x * 4,
                             gfx.players[i].ani.frames * gfx.players[i].smal_size.y);
            getRGBpixel (tmpimage1, 0, 0, &r, &g, &b);
            SDL_SetColorKey (tmpimage1, SDL_SRCCOLORKEY, SDL_MapRGB (tmpimage1->format, r, g, b));
            gfx.players[i].smal_image = SDL_DisplayFormat (tmpimage1);
            SDL_FreeSurface (tmpimage1);
            SDL_FreeSurface (tmpimage);

        }
    }

    /* load the death image */
    sprintf (filename, "%s/player/dead0.png", bman.datapath);
	tmpimage = IMG_Load (filename);
    if (tmpimage == NULL) {
        /* no image found - set field clear */
        printf ("Player Animation Could not be loaded (%s)\n", filename);
        exit (1);
    }

    gfx.dead.frames = tmpimage->h / (2* GFX_IMGSIZE);
    tmpimage1 = 
        scale_image (tmpimage, ((2 * sx * tmpimage->w) / (2 * GFX_IMGSIZE)),
                     gfx.dead.frames * (2 * sy));
    getRGBpixel (tmpimage1, 0, 0, &r, &g, &b);
    SDL_SetColorKey (tmpimage1, SDL_SRCCOLORKEY, SDL_MapRGB (tmpimage1->format, r, g, b));
    gfx.dead.image = SDL_DisplayFormat (tmpimage1);
    SDL_FreeSurface (tmpimage1);
    SDL_FreeSurface (tmpimage);


    /* load the illnessthing */
    sprintf (filename, "%s/player/playersick.png", bman.datapath);
    tmpimage = IMG_Load (filename);
    if (tmpimage == NULL) {
        printf ("Can't load image: %s\n", SDL_GetError ());
        exit (1);
    }
    gfx.ill.frames = tmpimage->h / (2 * GFX_IMGSIZE);
    tmpimage1 =
        scale_image (tmpimage, (2 * sx * tmpimage->w) / (2 * GFX_IMGSIZE),
                     gfx.ill.frames * (2 * sy));
    getRGBpixel (tmpimage1, 0, 0, &r, &g, &b);
    SDL_SetColorKey (tmpimage1, SDL_SRCCOLORKEY, SDL_MapRGB (tmpimage1->format, r, g, b));
    gfx.ill.image = SDL_DisplayFormat (tmpimage1);
    SDL_FreeSurface (tmpimage);
    SDL_FreeSurface (tmpimage1);

	
    /* load the respawn gfx */
    sprintf (filename, "%s/player/respawn.png", bman.datapath);
    tmpimage = IMG_Load (filename);
    if (tmpimage == NULL) {
        printf ("Can't load image: %s\n", SDL_GetError ());
        exit (1);
    }
    gfx.respawn.frames = tmpimage->h / (2 * GFX_IMGSIZE);
    gfx.respawn.image  =
        scale_image (tmpimage, (2 * sx * tmpimage->w) / (2 * GFX_IMGSIZE),
                     gfx.respawn.frames * (2 * sy)); 
    SDL_FreeSurface (tmpimage);
};


/* frees the player images */
void
gfx_free_players ()
{
    int i;

    for (i = 0; i < MAX_PLAYERS; i++) {
        if (gfx.players[i].ani.image != NULL)
            SDL_FreeSurface (gfx.players[i].ani.image);
        gfx.players[i].ani.image = NULL;
        if (gfx.players[i].smal_image != NULL)
            SDL_FreeSurface (gfx.players[i].smal_image);
        gfx.players[i].smal_image = NULL;
    }

    if (gfx.dead.image != NULL)
        SDL_FreeSurface (gfx.dead.image);
    if (gfx.ill.image != NULL)
        SDL_FreeSurface (gfx.ill.image);
    if (gfx.respawn.image != NULL)
        SDL_FreeSurface (gfx.respawn.image);
}


/* init the whole GFX Part */
void
gfx_init ()
{
    if (gfx.fullscreen)
        gfx.screen =
            SDL_SetVideoMode (gfx.res.x, gfx.res.y, gfx.bpp,
                              SDL_SWSURFACE | SDL_DOUBLEBUF | SDL_HWACCEL | SDL_FULLSCREEN);

    else
        gfx.screen =
            SDL_SetVideoMode (gfx.res.x, gfx.res.y, gfx.bpp,
                              SDL_SWSURFACE | SDL_DOUBLEBUF | SDL_HWACCEL);
    if (gfx.screen == NULL) {
        d_printf ("Unable to set video mode: %s\n", SDL_GetError ());
        return;
    }
    SDL_ShowCursor (SDL_DISABLE);
	gfx_blitupdaterectclear ();
    gfx_loaddata ();
};


void
gfx_loaddata ()
{
    int i, j;
    char filename[255];
    SDL_Surface *tmpimage,
     *tmpimage1;

    /* load the logo */
    sprintf (filename, "%s/gfx/logo.png", bman.datapath);
    tmpimage = IMG_Load (filename);
    if (tmpimage == NULL) {
        sprintf (bman.datapath, "data");
        sprintf (filename, "%s/gfx/logo.png", bman.datapath);
        tmpimage = IMG_Load (filename);
        if (tmpimage == NULL) {
            printf ("Can't load image: %s\n", SDL_GetError ());
            exit (1);
        }
    }
    tmpimage1 = scale_image (tmpimage, gfx.res.x, gfx.res.y);
    SDL_FreeSurface (tmpimage);
    SDL_SetColorKey (tmpimage1, SDL_SRCCOLORKEY, SDL_MapRGB (tmpimage1->format, 255, 255, 0));
    gfx.logo = SDL_DisplayFormat (tmpimage1);
    SDL_FreeSurface (tmpimage1);

	font_load ();
	
	/* load the menugraphics */
	for (i = 0; i < 9; i++) {
		sprintf (filename, "%s/gfx/menu%d.png", bman.datapath, i);
		menuimages[i] = IMG_Load (filename);
	    if (menuimages[i] == NULL) {
    	    printf ("Can't load image: %s\n", SDL_GetError ());
        	exit (1);
	    }
	}
	
	/* load menu buttongraphic */
	for (j = 0; j < 3; j++) 
		for (i = 0; i < 3; i++) {
			sprintf (filename, "%s/gfx/menubutton%d_%d.png", bman.datapath, j, i);
			tmpimage = IMG_Load (filename);
	    	if (tmpimage == NULL) {
	    	    printf ("Can't load image: %s\n", SDL_GetError ());
    	    	exit (1);
	    	}
		    SDL_SetColorKey (tmpimage, SDL_SRCCOLORKEY, SDL_MapRGB (tmpimage->format, 255, 255, 255));
    		menubuttonimages[j][i] = SDL_DisplayFormat (tmpimage);
	    	SDL_FreeSurface (tmpimage);
	}

	/* load menu buttongraphic */
	for (j = 0; j < 2; j++) 
		for (i = 0; i < 3; i++) {
			sprintf (filename, "%s/gfx/menuentry%d_%d.png", bman.datapath, j, i);
			tmpimage = IMG_Load (filename);
	    	if (tmpimage == NULL) {
	    	    printf ("Can't load image: %s\n", SDL_GetError ());
    	    	exit (1);
	    	}
		    SDL_SetColorKey (tmpimage, SDL_SRCCOLORKEY, SDL_MapRGB (tmpimage->format, 255, 255, 255));
    		menuentryimages[j][i] = SDL_DisplayFormat (tmpimage);
	    	SDL_FreeSurface (tmpimage);
	}
	
	/* load menu listgraphic */
	for (j = 0; j < 2; j++) 
		for (i = 0; i < 9; i++) {
			sprintf (filename, "%s/gfx/menulist%d_%d.png", bman.datapath, j, i);
			tmpimage = IMG_Load (filename);
	    	if (tmpimage == NULL) {
	    	    printf ("Can't load image: %s\n", SDL_GetError ());
    	    	exit (1);
	    	}
		    SDL_SetColorKey (tmpimage, SDL_SRCCOLORKEY, SDL_MapRGB (tmpimage->format, 255, 255, 255));
    		menulistimages[j][i] = SDL_DisplayFormat (tmpimage);
	    	SDL_FreeSurface (tmpimage);
	}
	
	/* load menuselect animation */
    sprintf (filename, "%s/gfx/menuselect.png", bman.datapath);
    gfx.menuselect.image = IMG_Load (filename);
    if (gfx.menuselect.image == NULL) {
        printf ("Can't load image: %s\n", SDL_GetError ());
        exit (1);
    }
    gfx.menuselect.frames = tmpimage->h / (2 * GFX_IMGSIZE);
};


void
gfx_shutdown ()
{
	int i, j;
	
	for (i = 0; i < 9; i++) {
		SDL_FreeSurface (menuimages[i]);
		if (i < 3)
			for (j = 0; j < 3; j++)	{
				SDL_FreeSurface (menubuttonimages[j][i]);
				if (j < 2) SDL_FreeSurface (menuentryimages[j][i]);
			}
		for (j = 0; j < 2; j++)
			SDL_FreeSurface (menulistimages[j][i]);
			
	}

    SDL_FreeSurface (gfx.logo);
    SDL_FreeSurface (gfx.menuselect.image);
    gfx.screen = SDL_SetVideoMode (gfx.res.x, gfx.res.y, 16, SDL_HWSURFACE | SDL_DOUBLEBUF);
    SDL_FreeSurface (gfx.screen);
	
	font_free();
};


void
draw_logo ()
{
	SDL_Rect dest;
	dest.x = dest.y = 0;
	dest.w = gfx.res.x;
	dest.h = gfx.res.y;
	
    SDL_BlitSurface (gfx.logo, NULL, gfx.screen, NULL);
    gfx_blitupdaterectadd (&dest);
};


void
redraw_logo_shaded (int x, int y, int w, int h, int c)
{
    SDL_Rect dest;
    dest.w = w;
    dest.h = h;
    dest.x = x;
    dest.y = y;
    redraw_logo (x, y, w + 1, h + 1);
    if (gfx_locksurface (gfx.screen))
        return;
    dest.h += dest.y;
    dest.w += dest.x;
    draw_shadefield (gfx.screen, &dest, c);
    gfx_unlocksurface (gfx.screen);
};


void
redraw_logo (int x, int y, int w, int h)
{
    SDL_Rect src,
      dest;
    dest.w = src.w = w;
    dest.h = src.h = h;
    dest.x = x;
    dest.y = y;
    src.x = x;
    src.y = y;
    SDL_BlitSurface (gfx.logo, &src, gfx.screen, &dest);
	gfx_blitupdaterectadd (&dest);
};



void
shade_pixel (SDL_Surface * s, int x, int y, int c)
{
    Uint32 p;
    Uint8 r,
      g,
      b;
    p = getpixel (s, x, y);
    SDL_GetRGB (p, s->format, &r, &g, &b);
    if (c > 0) {
        if (((Sint16) r) + c < 256) {
            r += c;
        }
        else
            r = 255;
        if (((Sint16) g) + c < 256) {
            g += c;
        }
        else
            g = 255;
        if (((Sint16) b) + c < 256) {
            b += c;
        }
        else
            b = 255;
    }

    else {
        if (((Sint16) r) + c > 0) {
            r += c;
        }
        else
            r = 0;
        if (((Sint16) g) + c > 0) {
            g += c;
        }
        else
            g = 0;
        if (((Sint16) b) + c > 0) {
            b += c;
        }
        else
            b = 0;
    }
    p = SDL_MapRGB (s->format, r, g, b);
    putpixel (s, x, y, p);
};


int
gfx_locksurface (SDL_Surface * surface)
{
    if (SDL_MUSTLOCK (surface))
        if (SDL_LockSurface (surface) < 0) {
            fprintf (stderr, "Can't lock screen: %s\n", SDL_GetError ());
            return -1;
        }
    return 0;
};



void
gfx_unlocksurface (SDL_Surface * surface)
{
    if (SDL_MUSTLOCK (surface)) {
        SDL_UnlockSurface (surface);
    }
};


void
draw_shadefield (SDL_Surface * s, SDL_Rect * rec, int c)
{
    int x1,
      x,
      x2,
      y1,
      y;
    if (rec->x > rec->w) {
        x1 = rec->w;
        x2 = rec->x;
    }

    else {
        x2 = rec->w;
        x1 = rec->x;
    }
    if (rec->y > rec->h) {
        y = rec->h;
        y1 = rec->y;
    }

    else {
        y1 = rec->h;
        y = rec->y;
    }
    for (; y <= y1; y++)
        for (x = x1; x <= x2; x++)
            shade_pixel (s, x, y, c);
};
