/***************************************************************************
 *            bonfire-layout.h
 *
 *  mer mai 24 15:14:42 2006
 *  Copyright  2006  Rouquier Philippe
 *  bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef BONFIRE_LAYOUT_H
#define BONFIRE_LAYOUT_H

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtkuimanager.h>
#include <gtk/gtkhpaned.h>

G_BEGIN_DECLS

#define BONFIRE_TYPE_LAYOUT         (bonfire_layout_get_type ())
#define BONFIRE_LAYOUT(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_LAYOUT, BonfireLayout))
#define BONFIRE_LAYOUT_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_LAYOUT, BonfireLayoutClass))
#define BONFIRE_IS_LAYOUT(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_LAYOUT))
#define BONFIRE_IS_LAYOUT_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_LAYOUT))
#define BONFIRE_LAYOUT_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_LAYOUT, BonfireLayoutClass))

typedef struct BonfireLayoutPrivate BonfireLayoutPrivate;

typedef enum {
	BONFIRE_LAYOUT_NONE		= 0,
	BONFIRE_LAYOUT_AUDIO		= 1,
	BONFIRE_LAYOUT_DATA		= 1 << 1,
} BonfireLayoutType;

typedef struct {
	GtkHPaned parent;
	BonfireLayoutPrivate *priv;
} BonfireLayout;

typedef struct {
	GtkHPanedClass parent_class;
} BonfireLayoutClass;

GType bonfire_layout_get_type ();
GtkWidget *bonfire_layout_new ();

void
bonfire_layout_add_project (BonfireLayout *layout,
			    GtkWidget *project);
void
bonfire_layout_add_preview (BonfireLayout*layout,
			    GtkWidget *preview);

void
bonfire_layout_add_source (BonfireLayout *layout,
			   GtkWidget *child,
			   const char *id,
			   const char *name,
			   const char *menu,
			   const char *tooltip,
			   const char *icon,
			   BonfireLayoutType types);
void
bonfire_layout_load (BonfireLayout *layout, BonfireLayoutType type);

void
bonfire_layout_register_menu (BonfireLayout *layout,
			      GtkUIManager *manager);

#endif /* BONFIRE_LAYOUT_H */
