/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/***************************************************************************
*            play-list.h
*
*  mer mai 25 22:22:53 2005
*  Copyright  2005  Philippe Rouquier
*  bonfire-app@wanadoo.fr
****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifdef BUILD_PLAYLIST

#ifndef PLAY_LIST_H
#define PLAY_LIST_H

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtkvbox.h>

G_BEGIN_DECLS
#define BONFIRE_TYPE_PLAYLIST         (bonfire_playlist_get_type ())
#define BONFIRE_PLAYLIST(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_PLAYLIST, BonfirePlaylist))
#define BONFIRE_PLAYLIST_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_PLAYLIST, BonfirePlaylistClass))
#define BONFIRE_IS_PLAY_LIST(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_PLAYLIST))
#define BONFIRE_IS_PLAY_LIST_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_PLAYLIST))
#define BONFIRE_PLAYLIST_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_PLAYLIST, BonfirePlaylistClass))
typedef struct BonfirePlaylistPrivate BonfirePlaylistPrivate;

typedef struct {
	GtkVBox parent;
	BonfirePlaylistPrivate *priv;
} BonfirePlaylist;

typedef struct {
	GtkVBoxClass parent_class;
} BonfirePlaylistClass;

GType bonfire_playlist_get_type ();
GtkWidget *bonfire_playlist_new ();

#endif				/* PLAY_LIST_H */

#endif
