/***************************************************************************
 *            project-size.h
 *
 *  dim nov 27 14:33:46 2005
 *  Copyright  2005  Rouquier Philippe
 *  bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PROJECT_SIZE_H
#define PROJECT_SIZE_H

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtkhbox.h>

G_BEGIN_DECLS

#define BONFIRE_TYPE_PROJECT_SIZE         (bonfire_project_size_get_type ())
#define BONFIRE_PROJECT_SIZE(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_PROJECT_SIZE, BonfireProjectSize))
#define BONFIRE_PROJECT_SIZE_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_PROJECT_SIZE, BonfireProjectSizeClass))
#define BONFIRE_IS_PROJECT_SIZE(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_PROJECT_SIZE))
#define BONFIRE_IS_PROJECT_SIZE_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_PROJECT_SIZE))
#define BONFIRE_PROJECT_SIZE_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_PROJECT_SIZE, BonfireProjectSizeClass))

typedef struct BonfireProjectSizePrivate BonfireProjectSizePrivate;

typedef struct {
	GtkHBox parent;
	BonfireProjectSizePrivate *priv;
} BonfireProjectSize;

typedef struct {
	GtkHBoxClass parent_class;

	void (*disc_changed)	(BonfireProjectSize *size);
} BonfireProjectSizeClass;

GType bonfire_project_size_get_type();
GtkWidget *bonfire_project_size_new();

void
bonfire_project_size_set_size (BonfireProjectSize *obj,
			       double size,
			       const char *string);

void
bonfire_project_size_set_context (BonfireProjectSize *size,
				  gboolean is_audio);

gboolean
bonfire_project_size_check_status (BonfireProjectSize *obj,
				   gboolean *overburn);

#endif /* PROJECT_SIZE_H */
