/***************************************************************************
 *            project.h
 *
 *  mar nov 29 09:32:17 2005
 *  Copyright  2005  Rouquier Philippe
 *  bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PROJECT_H
#define PROJECT_H

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtkwidget.h>
#include <gtk/gtkvbox.h>

#include <gtk/gtkuimanager.h>

#include "disc.h"
#include "bonfire-uri-container.h"
#include "project-type-chooser.h"

G_BEGIN_DECLS

#define BONFIRE_TYPE_PROJECT         (bonfire_project_get_type ())
#define BONFIRE_PROJECT(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_PROJECT, BonfireProject))
#define BONFIRE_PROJECT_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_PROJECT, BonfireProjectClass))
#define BONFIRE_IS_PROJECT(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_PROJECT))
#define BONFIRE_IS_PROJECT_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_PROJECT))
#define BONFIRE_PROJECT_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_PROJECT, BonfireProjectClass))

typedef struct BonfireProjectPrivate BonfireProjectPrivate;

typedef struct {
	GtkVBox parent;
	BonfireProjectPrivate *priv;
} BonfireProject;

typedef struct {
	GtkVBoxClass parent_class;
} BonfireProjectClass;

GType bonfire_project_get_type ();
GtkWidget *bonfire_project_new ();

void
bonfire_project_set_audio (BonfireProject *project);
void
bonfire_project_set_data (BonfireProject *project);
void
bonfire_project_set_none (BonfireProject *project);

void
bonfire_project_add_source (BonfireProject *project,
			    BonfireURIContainer *source);

BonfireProjectType
bonfire_project_open_project (BonfireProject *project, const char *uri);
gboolean
bonfire_project_save_project (BonfireProject *project);
gboolean
bonfire_project_save_project_as (BonfireProject *project);

void
bonfire_project_register_menu (BonfireProject *project, GtkUIManager *manager);

#endif /* PROJECT_H */
