/***************************************************************************
*            recorder-selection.h
*
*  mer jun 15 12:40:07 2005
*  Copyright  2005  Philippe Rouquier
*  bonfire-app@wanadoo.fr
****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef RECORDER_SELECTION_H
#define RECORDER_SELECTION_H

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtkhbox.h>

#include <nautilus-burn-drive.h>

#include "burn.h"

G_BEGIN_DECLS
#define BONFIRE_TYPE_RECORDER_SELECTION         (bonfire_recorder_selection_get_type ())
#define BONFIRE_RECORDER_SELECTION(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_RECORDER_SELECTION, BonfireRecorderSelection))
#define BONFIRE_RECORDER_SELECTION_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_RECORDER_SELECTION, BonfireRecorderSelectionClass))
#define BONFIRE_IS_RECORDER_SELECTION(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_RECORDER_SELECTION))
#define BONFIRE_IS_RECORDER_SELECTION_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_RECORDER_SELECTION))
#define BONFIRE_RECORDER_SELECTION_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_RECORDER_SELECTION, BonfireRecorderSelectionClass))
typedef struct BonfireRecorderSelectionPrivate BonfireRecorderSelectionPrivate;

typedef struct {
	union {
		gint drive_speed;
		BonfireTrackSourceType image_type;
	} props;

	char *output_path;
	BonfireBurnFlag flags;
} BonfireDriveProp;

typedef struct {
	GtkHBox parent;
	BonfireRecorderSelectionPrivate *priv;
} BonfireRecorderSelection;

typedef struct {
	GtkHBoxClass parent_class;

	/* signal */
	void		(*media_changed)	(BonfireRecorderSelection *selection,
						 NautilusBurnMediaType type);

} BonfireRecorderSelectionClass;

GType bonfire_recorder_selection_get_type ();

GtkWidget *
bonfire_recorder_selection_new ();

void
bonfire_recorder_selection_select_default_drive (BonfireRecorderSelection *selection,
						 BonfireMediaType type);
void
bonfire_recorder_selection_set_track_type (BonfireRecorderSelection *selection,
					   BonfireTrackSourceType type);
void
bonfire_recorder_selection_set_src_media_type (BonfireRecorderSelection *selection,
					       NautilusBurnMediaType type);
void
bonfire_recorder_selection_get_drive (BonfireRecorderSelection *selection,
				      NautilusBurnDrive **drive,
				      BonfireDriveProp *props);

#endif				/* RECORDER_SELECTION_H */
