#region license
// Copyright (c) 2003, 2004, 2005 Rodrigo B. de Oliveira (rbo@acm.org)
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
//     * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//     * Neither the name of Rodrigo B. de Oliveira nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#endregion

//
// DO NOT EDIT THIS FILE!
//
// This file was generated automatically by astgen.boo.
//

namespace Boo.Lang.Compiler.Ast.Impl
{	
	using Boo.Lang.Compiler.Ast;
	using System.Collections;
	using System.Runtime.Serialization;
	
	[System.Serializable]
	public abstract class CallableBlockExpressionImpl : Expression, INodeWithParameters
	{
		protected ParameterDeclarationCollection _parameters;

		protected TypeReference _returnType;

		protected Block _body;

		protected CallableBlockExpressionImpl()
		{
			InitializeFields();
		}
		
		protected CallableBlockExpressionImpl(LexicalInfo info) : base(info)
		{
			InitializeFields();
		}
		
		protected CallableBlockExpressionImpl(TypeReference returnType)
		{
			InitializeFields();
			ReturnType = returnType;
		}
			
		protected CallableBlockExpressionImpl(LexicalInfo lexicalInfo, TypeReference returnType) : base(lexicalInfo)
		{
			InitializeFields();
			ReturnType = returnType;
		}

		new public CallableBlockExpression CloneNode()
		{
			return Clone() as CallableBlockExpression;
		}

		override public NodeType NodeType
		{
			get
			{
				return NodeType.CallableBlockExpression;
			}
		}
		
		override public bool Matches(Node node)
		{	
			CallableBlockExpression other = node as CallableBlockExpression;
			if (null == other) return false;
			if (!Node.Matches(_parameters, other._parameters)) return false;
			if (!Node.Matches(_returnType, other._returnType)) return false;
			if (!Node.Matches(_body, other._body)) return false;
			return true;
		}
	
		override public bool Replace(Node existing, Node newNode)
		{
			if (base.Replace(existing, newNode))
			{
				return true;
			}
			if (_parameters != null)
			{
				ParameterDeclaration item = existing as ParameterDeclaration;
				if (null != item)
				{
					ParameterDeclaration newItem = (ParameterDeclaration)newNode;
					if (_parameters.Replace(item, newItem))
					{
						return true;
					}
				}
			}
			if (_returnType == existing)
			{
				this.ReturnType = (TypeReference)newNode;
				return true;
			}
			if (_body == existing)
			{
				this.Body = (Block)newNode;
				return true;
			}
			return false;
		}
		
		override public object Clone()
		{
			CallableBlockExpression clone = (CallableBlockExpression)FormatterServices.GetUninitializedObject(typeof(CallableBlockExpression));
			clone._lexicalInfo = _lexicalInfo;
			clone._endSourceLocation = _endSourceLocation;
			clone._documentation = _documentation;
			//clone._entity = _entity;
			clone._annotations = (Hashtable)_annotations.Clone();
		
			clone._expressionType = _expressionType;
			if (null != _parameters)
			{
				clone._parameters = _parameters.Clone() as ParameterDeclarationCollection;
				clone._parameters.InitializeParent(clone);
			}
			if (null != _returnType)
			{
				clone._returnType = _returnType.Clone() as TypeReference;
				clone._returnType.InitializeParent(clone);
			}
			if (null != _body)
			{
				clone._body = _body.Clone() as Block;
				clone._body.InitializeParent(clone);
			}
			return clone;
		}
		
		override internal void ClearTypeSystemBindings()
		{
			_annotations.Clear();
			//_entity = null;
			_expressionType = null;
			if (null != _parameters)
			{
				_parameters.ClearTypeSystemBindings();
			}
			if (null != _returnType)
			{
				_returnType.ClearTypeSystemBindings();
			}
			if (null != _body)
			{
				_body.ClearTypeSystemBindings();
			}

		}
	

		[System.Xml.Serialization.XmlElement]
		public ParameterDeclarationCollection Parameters
		{
			get
			{
				return _parameters;
			}

			set
			{
				if (_parameters != value)
				{
					_parameters = value;
					if (null != _parameters)
					{
						_parameters.InitializeParent(this);
					}
				}
			}

		}
		

		[System.Xml.Serialization.XmlElement]
		public TypeReference ReturnType
		{
			get
			{
				return _returnType;
			}

			set
			{
				if (_returnType != value)
				{
					_returnType = value;
					if (null != _returnType)
					{
						_returnType.InitializeParent(this);
					}
				}
			}

		}
		

		[System.Xml.Serialization.XmlElement]
		public Block Body
		{
			get
			{
				return _body;
			}

			set
			{
				if (_body != value)
				{
					_body = value;
					if (null != _body)
					{
						_body.InitializeParent(this);
					}
				}
			}

		}
		
		private void InitializeFields()
		{

			_parameters = new ParameterDeclarationCollection(this);
			_body = new Block();
			_body.InitializeParent(this);

		}
	}
}

