/***************************************************************************
                          bridgecfg.h  -  description
                             -------------------
    begin                : Mon Nov 18 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kenschenke at yahoo dot com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, as a special exception, Ken Schenke gives permission to  *
 *   link the code of this program with the Qt non-commercial edition (or  *
 *   with modified versions of the Qt non-commercial edition that use the  *
 *   same license as the Qt non-commercial edition, and distribute linked  *
 *   combinations including the two.  You must obey the GNU General Public *
 *   License in all respects for all of the code used other than the Qt    *
 *   Non-Commercial edition.  If you modify this file, you may extend this *
 *   exception to your version of the file, but you are not obligated to   *
 *   do so.  If you do not wish to do so, delete this exception statement  *
 *   from your version.                                                    *
 *                                                                         *
 ***************************************************************************/

#ifndef BRIDGECFG_H
#define BRIDGECFG_H

#include "bknode.h"
#include "bkexcept.h"

#include <vector>
#include <string>

/***************************************************************************
 *                                                                         *
 *   This class stores configuration information on a browser.             *
 *                                                                         *
 ***************************************************************************/

class BrowserCfg
{
public:
	BrowserCfg() : m_readOnly(false)
	{
		m_ordinal = rand();
	}
	BrowserCfg(const BrowserCfg &cfg) :
		m_browser(cfg.m_browser),
		m_browserNum(cfg.m_browserNum),
		m_descrip(cfg.m_descrip),
		m_location(cfg.m_location),
		m_readOnly(cfg.m_readOnly),
		m_ordinal(cfg.m_ordinal)
	{ };
	~BrowserCfg() { };

	BrowserCfg & operator=(const BrowserCfg &cfg)
	{
		m_browser = cfg.m_browser;
		m_descrip = cfg.m_descrip;
		m_location = cfg.m_location;
		m_readOnly = cfg.m_readOnly;
		m_browserNum = cfg.m_browserNum;
		m_ordinal = cfg.m_ordinal;

		return *this;
	}

	bool		operator==(BRWSNUM ordinal) { return m_ordinal == ordinal; }

	std::string	browser(void) const { return m_browser; }
	BRWSTYPE	browserNum(void) const { return m_browserNum; }
	std::string	descrip(void) const { return m_descrip; }
	std::string	location(void) const { return m_location; }
	bool		readOnly(void) const { return m_readOnly; }
	BRWSNUM		ordinal(void) const { return m_ordinal; }

	void		setBrowser(const char *browser) { m_browser = browser; }
	void		setBrowserNum(BRWSTYPE browserNum) { m_browserNum = browserNum; }
	void		setDescrip(const char *descrip) { m_descrip = descrip; }
	void		setLocation(const char *location) { m_location = location; }
	void		setReadOnly(bool readOnly) { m_readOnly = readOnly; }
	void		setOrdinal(BRWSNUM ordinal) { m_ordinal = ordinal; }

private:
	std::string	m_browser;
	BRWSTYPE	m_browserNum;
	std::string	m_descrip;
	std::string	m_location;
	bool		m_readOnly;
	BRWSNUM		m_ordinal;
};

/***************************************************************************
 *                                                                         *
 *   This class stores configuration for BookmarkBridge.                   *
 *                                                                         *
 ***************************************************************************/

class BridgeCfg
{
public:
	BridgeCfg() throw(BkException)
		: configFileName(""), xbelFileName("") { findConfigFile(); }
	BridgeCfg(const BridgeCfg &cfg) :
		browsers(cfg.browsers),
		sources(cfg.sources),
		destinations(cfg.destinations),
		datadir(cfg.datadir)
#ifdef Q_WS_WIN
		,appdatadir(cfg.appdatadir),
		favoritesdir(cfg.favoritesdir),
		progfilesdir(cfg.progfilesdir)
#endif
		{ }

	BridgeCfg & operator=(const BridgeCfg &cfg)
	{
		browsers = cfg.browsers;
		sources = cfg.sources;
		destinations = cfg.destinations;
		datadir = cfg.datadir;
#ifdef Q_WS_WIN
		appdatadir = cfg.appdatadir;
		progfilesdir = cfg.progfilesdir;
		favoritesdir = cfg.favoritesdir;
#endif

		return *this;
	}

	void		readBookmarksXbel(BkFolder **root) throw(BkException);
	void		readConfig(void) throw(BkException);
	void		writeBookmarksXbel(const BkFolder &root) throw(BkException);
	void		writeConfig(void) throw(BkException);

	std::vector<BrowserCfg>
				browsers;
	std::vector<BRWSNUM>
				sources;
	std::vector<BRWSNUM>
				destinations;

	std::string	datadir;
#ifdef Q_WS_WIN
	std::string appdatadir;		// Application Data directory (Windows)
	std::string favoritesdir;	// Favorites directory (Windows)
	std::string progfilesdir;	// Program Files directory (Windows)
#endif

private:
	std::string	configFileName;
	std::string	xbelFileName;
	bool		configFileExists;
	bool		xbelFileExists;

	void		findConfigFile(void) throw(BkException);
#ifdef Q_WS_WIN
	void		InitMemberVars(void) throw(BkException);
#endif
	void		InitDefaults(void) throw(BkException);
};

#endif  // end of BRIDGECFG_H
