/***************************************************************************
                          dlgaddbrowser.cpp  -  description
                             -------------------
    begin                : Sat Nov 16 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kenschenke at yahoo dot com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, as a special exception, Ken Schenke gives permission to  *
 *   link the code of this program with the Qt non-commercial edition (or  *
 *   with modified versions of the Qt non-commercial edition that use the  *
 *   same license as the Qt non-commercial edition, and distribute linked  *
 *   combinations including the two.  You must obey the GNU General Public *
 *   License in all respects for all of the code used other than the Qt    *
 *   Non-Commercial edition.  If you modify this file, you may extend this *
 *   exception to your version of the file, but you are not obligated to   *
 *   do so.  If you do not wish to do so, delete this exception statement  *
 *   from your version.                                                    *
 *                                                                         *
 ***************************************************************************/

#include "dlgaddbrowser.h"
#include "browserlist.h"

extern BROWSERLIST BrowserList[];

#include <vector>
#include <string>
#include <stdlib.h>
#include <time.h>

#include <qlistview.h>
#include <qpushbutton.h>
#include <qmessagebox.h>

using namespace std;

/***************************************************************************
 *                                                                         *
 *   The BrowserAddItem class (derived from QListViewItem) represents an   *
 *   item in the ListView used in this dialog.  Really it is only used to  *
 *   store the ordinal representing the browser.                           *
 *                                                                         *
 ***************************************************************************/
 
class BrowserAddItem : public QListViewItem
{
public:
	BrowserAddItem(QListView *parent) : QListViewItem(parent) { };

	BRWSNUM ordinal;
};

/***************************************************************************
 *                                                                         *
 *   DlgAddBrowser::DlgAddBrowser()                                        *
 *                                                                         *
 *   Parameters:                                                           *
 *      const vector<BrowserCfg> browsers                                  *
 *      QWidget *parent                                                    *
 *      const char *name                                                   *
 *      bool modal                                                         *
 *      WFlags f                                                           *
 *   Return:                                                               *
 *      None                                                               *
 *   Description:                                                          *
 *      Class constructor.  The first parameter contains a vector of the   *
 *      the browsers to display.                                           *
 *                                                                         *
 ***************************************************************************/

DlgAddBrowser::DlgAddBrowser(
	const vector<BrowserCfg> &browsers,
	QWidget* parent,
	const char* name,
	bool modal,
	WFlags f)
	: DlgAddBrowserBase( parent, name, modal, f ), m_browsers(browsers)
{
	ordinal = 0;
	refreshList();
	refreshButtons();
}

/***************************************************************************
 *                                                                         *
 *   DlgAddBrowser::~DlgAddBrowser()                                       *
 *                                                                         *
 *   Parameters:                                                           *
 *      None                                                               *
 *   Return:                                                               *
 *      None                                                               *
 *   Description:                                                          *
 *      Class destructor                                                   *
 *                                                                         *
 ***************************************************************************/

DlgAddBrowser::~DlgAddBrowser()
{
}

/***************************************************************************
 *                                                                         *
 *   DlgAddBrowser::refreshButtons()                                       *
 *                                                                         *
 *   Parameters:                                                           *
 *      None                                                               *
 *   Return:                                                               *
 *      None                                                               *
 *   Description:                                                          *
 *      This function is called whenever the state of the dialog box       *
 *      changes, i.e. the user clicks on a browser.  All it does is enable *
 *      disable the Add button.                                            *
 *                                                                         *
 ***************************************************************************/

void DlgAddBrowser::refreshButtons(void)
{
	buttonAdd->setEnabled(listBrowsers->selectedItem() != NULL);
}

/***************************************************************************
 *                                                                         *
 *   DlgAddBrowser::refreshList()                                          *
 *                                                                         *
 *   Parameters:                                                           *
 *      None                                                               *
 *   Return:                                                               *
 *      None                                                               *
 *   Description:                                                          *
 *      This function is called to populate the browser list.              *
 *                                                                         *
 ***************************************************************************/

void DlgAddBrowser::refreshList(void)
{
	vector<BrowserCfg>::const_iterator it;

	listBrowsers->clear();

	for(it=m_browsers.begin(); it!=m_browsers.end(); ++it)
	{
		BrowserAddItem *item = new BrowserAddItem(listBrowsers);
		item->setText(0, it->browser().c_str());
		item->setText(1, it->descrip().c_str());
		item->ordinal = it->ordinal();
	}
}

/***************************************************************************
 *                                                                         *
 *   DlgAddBrowser::listBrowsersSelectionChanged()                         *
 *                                                                         *
 *   Parameters:                                                           *
 *      QListViewItem *pItem                                               *
 *   Return:                                                               *
 *      None                                                               *
 *   Description:                                                          *
 *      This function (really a slot) is called to by the Qt framework     *
 *      the user selects (or deselects) an item in the browsers list.  The *
 *      selected item is passed as pItem or NULL if not item is selected.  *
 *                                                                         *
 ***************************************************************************/

void DlgAddBrowser::listBrowsersSelectionChanged(QListViewItem *pItem)
{
	// Enable or disable the Add button
	
	refreshButtons();

	// If no item was selected, clear the current ordinal and return
	
	if(pItem == NULL)
	{
		ordinal = 0;
		return;
	}

	// Store the ordinal of the currently selected item
	
	BrowserAddItem *item = static_cast<BrowserAddItem *>(pItem);
	ordinal = item->ordinal;
}
