[-- template default.template --]
[-- define title=Theory of Operation --]
[-- define chapter_title=3. How BookmarkBridge Works --]
[-- define prev_link=# --]
[-- define prev_title=None --]
[-- define next_link=compiling_bookmarkbridge_from_source.html --]
[-- define next_title=Compiling BookmarkBridge From Source --]

<p>
While seemingly simple from appearance, BookmarkBridge is actually a rather complex
program under the hood.  This section attempts to explain how BookmarkBridge works.
This entire chapter is intended for a technical audience.  It is not necessary to
understand any of this chapter in order to successfully use BookmarkBridge.  However,
for the curious I have provided this information.  Furthermore, it can be helpful to
understand how something works and what it is trying do in order to troubleshoot and
fix a problem.
</p>

<h3>The Bookmark Tree</h3>
<p>
Whenever the user asks BookmarkBridge to view or merge bookmarks, it reads the bookmarks
from every configured browser and combines these into an internal bookmark tree.  It
keeps this tree in memory and it becomes the master copy of bookmarks that are either
displayed to the user or saved to each browser.  This tree consists of all bookmarks
and folders.  The tree starts with an un-named, root folder.  This root folder contains
all bookmarks that are not, themselves, in a separate folder.  This root folder also
contains all first-level subfolders.  These subfolders can then contain more bookmarks
and folders.  If the user chooses to view their bookmarks, they are actually viewing a
representation of this tree.
</p>

<p>
Once this tree has been generated, BookmarkBridge saves it to a file, usually called
bookmarks.xbel.  See <a href="configuration_files.html">Appendix C - Configuration
Files</a> for more information.  This happens even if the user just views their
bookmarks.
</p>

<h3>Reading the Bookmarks</h3>
<p>
When BookmarkBridge is asked to view or merge bookmarks, it first reads the bookmark
tree, if any, from any previous invocation.  It then calls on an internal module
for each configured browser to read bookmarks into memory.  BookmarkBridge has such a
module for each browser it supports.  These modules read their browser's bookmarks into
a tree belonging to that browser.  Later that tree is merged into a combined tree
consisting of bookmarks from each browser.  Once the bookmarks from all browsers have
been read, BookmarkBridge knows which browsers have which bookmarks and folders.  If it
was able to find a copy of the bookmark tree from the last time it was run, it is able
to know if a bookmark or folder was previously saved in a browser but is no longer
present.  It also knows which bookmarks are different between the browsers and which
bookmarks are new.
</p>

<h3>Saving Bookmarks</h3>
<p>
Once a combined bookmark tree has been produced from the bookmarks of each browser,
BookmarkBridge then calls again on the module for each configured browser to save the
new bookmark tree out to the browsers.
</p>
