#
# Copyright (C) 2000  Motoyuki Kasahara
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

#
# Load messages file.
#
proc message_load_file {directory} {
    global env
    global messages

    #
    # Load messages file.  The default is "ja".
    #
    set language ""
    if {[catch {set language $env(BOOKVIEW_LANG)}]} {
	set language "ja"
    }

    if {$language == "en"} {
	return
    }

    catch {source "$directory/$language.mo"}
}

#
# Convert a message to other language.
# If the message `id' doesn't exist, `id' itself is used as message.
#
proc _ {id} {
    global messages

    if {[catch {set message $messages($id)}]} {
	set message $id
    } else {
	set message $messages($id)
    }

    return $message
}

#
# Convert a message to other language.
# If the message `id' doesn't exist, `default' is used.
#
proc __ {default id} {
    global messages

    if {[catch {set message $messages($id)}]} {
	set message $default
    } else {
	set message $messages($id)
    }

    return $message
}
