#include <signal.h>
#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include "dbootstrap.h"
#include "lang.h"
#include <syslog.h> 
#include "util.h"
#include <sys/mount.h>
#ifdef _TESTING_
# include <stdio.h>
#endif

int write_static_network();
extern int use_dhcp;
extern char *netinterface;

int halt_system (void) {
#if #cpu(s390)
  char buffer1[PATH_MAX];
  char buffer2[PATH_MAX];
  struct stat statbuf;
#endif  
  int write_common_network (void);
  sync();
  if (! bootargs.isquiet ) {
    if (! bootargs.isquiet && ! yesNoBox(_("Linux for S/390 does not support rebooting into the installed system. You may halt the system and then IPL the installed system from the DASD using the S/390 facilities. After that please reconnect using telnet and log in as root to finish the installation.\n\nHalt the system?"), _("Halt the system?")) )
	return 1;
  }

  if(!is_network_configured())
    write_common_network();

#if #cpu(s390)
  if(!netinterface && !use_dhcp) {
  /* in case network configuration was not touched */
    execlog("cp -a /etc/hostname /target/etc/", LOG_INFO);
    execlog("cp -a /etc/networks /target/etc/", LOG_INFO);
    execlog("cp -a /etc/hosts /target/etc/", LOG_INFO);
    execlog("cp -a /etc/resolv.conf /target/etc/", LOG_INFO);
    execlog("cp -a /etc/network/interfaces /target/etc/network/", LOG_INFO);
  }

  /* copy available network modules */
  sprintf(buffer1, "/lib/modules.old/%s/kernel/drivers/s390/net/qdio.o", kver);
  sprintf(buffer2, "/target/lib/modules/%s/kernel/drivers/s390", kver);
  if(NAME_ISREG (buffer1, &statbuf) && NAME_ISDIR (buffer2, &statbuf)) {
    sprintf(buffer1, "cp -a /lib/modules.old/%s/kernel/drivers/s390/net/qdio.o /target/lib/modules/%s/kernel/drivers/s390/", kver, kver);
    execlog(buffer1, LOG_INFO);
  }
  sprintf(buffer1, "/lib/modules.old/%s/kernel/drivers/s390/net/qeth.o", kver);
  sprintf(buffer2, "/target/lib/modules/%s/kernel/drivers/s390/net", kver);
  if(NAME_ISREG (buffer1, &statbuf) && NAME_ISDIR (buffer2, &statbuf)) {
    sprintf(buffer1, "cp -a /lib/modules.old/%s/kernel/drivers/s390/net/qeth.o /target/lib/modules/%s/kernel/drivers/s390/net/", kver, kver);
    execlog(buffer1, LOG_INFO);
  }
  sprintf(buffer1, "/lib/modules.old/%s/kernel/drivers/s390/net/lcs.o", kver);
  sprintf(buffer2, "/target/lib/modules/%s/kernel/drivers/s390/net", kver);
  if(NAME_ISREG (buffer1, &statbuf) && NAME_ISDIR (buffer2, &statbuf)) {
    sprintf(buffer1, "cp -a /lib/modules.old/%s/kernel/drivers/s390/net/lcs.o /target/lib/modules/%s/kernel/drivers/s390/net/", kver, kver);
    execlog(buffer1, LOG_INFO);
  }
 
  /* copy module configuration from initial network setup */
/*
  execlog("/target/bin/cp -pu /etc/chandev.modules /target/etc/", LOG_INFO);
*/
  execlog("mkdir -p /target/etc/modutils/arch", LOG_INFO);
  execlog("/target/bin/cp -pu /etc/modutils/arch/s390 /target/etc/modutils/arch", LOG_INFO);
  execlog("/target/bin/cp -pu /etc/modutils/* /target/etc/modutils/", LOG_INFO);
  execlog("chroot /target /sbin/update-modules force", LOG_INFO);
#endif

  execlog("cp /var/log/messages /target/var/log/installer.log", LOG_INFO);

  sync();
  boxSuspend();
  system("halt");
  sleep(15);
  boxResume();
  return 1;
}


