#include <stdio.h>
#include <string.h>

#include "langs.h"

typedef enum {
    KEYMAP,
    FONT,
} output_type;

    void dump (output_type what);

int
main (int argc, char **argv)
{
    int code;

    if (argc == 1)
    {
        fprintf (stderr, "Usage: bf-info ( keymaps | fonts )\n");

        code = 1;
    }
    else
    {
        if (strcasecmp (argv[1], "keymaps") == 0)
            dump (KEYMAP);
        else if (strcasecmp (argv[1], "fonts") == 0)
            dump (FONT);
        else
        {
            fprintf (stderr, "Unknown command: %s\n", argv[1]);

            code = 2;
        }
    }

    return code;
}

    void dump_variants (const char *, const struct language_list *, output_type);

void
dump (output_type what)
{
    const struct language_definition *languages = available_languages (), *lang;

    for (lang = languages ; lang->name != NULL ; ++lang)
    {
        switch (what)
        {
            case FONT:
                printf ("%s %s %s\n", lang->ename, lang->font, lang->acm);
                break;

            default:
                ;
        }

        dump_variants (lang->ename, lang->list, what);
    }
}

void
dump_variants (const char *lang_name, const struct language_list *_, output_type what)
{
    int i;

    for (i = 0 ; _->items[i].d != 0 ; ++i)
        switch (_->items[i].d)
        {
            case 1:     // Item!
                {
                    const struct language_item *item = ((const struct language_item *)_->items[i].p);

                    switch (what)
                    {
                        case KEYMAP:
                            printf ("%s %s\n", lang_name, item->keymap);  // Note: it output \n at the end of line
                            break;

                        case FONT:
                            printf ("%s %s %s\n", lang_name, item->font, item->acm);
                            break;

                        default:
                            ;
                    }
                }
                break;

            case 2:
                dump_variants (lang_name, (const struct language_list *)_->items[i].p, what);
                break;
        }
}
