/*************************************************
* HAVAL Header File                              *
* (C) 1999-2005 The Botan Project                *
*************************************************/

#ifndef BOTAN_HAVAL_H__
#define BOTAN_HAVAL_H__

#include <botan/mdx_hash.h>

namespace Botan {

/*************************************************
* HAVAL                                          *
*************************************************/
class HAVAL : public MDx_HashFunction
   {
   public:
      void clear() throw();
      std::string name() const;
      HashFunction* clone() const { return new HAVAL(OUTPUT_LENGTH); }
      HAVAL(u32bit, u32bit = 5);
   private:
      void hash(const byte[]);
      void copy_out(byte[]);

      void write_count(byte[]);
      void tailor_digest();

      static const u32bit VERSION = 1;
      SecureBuffer<u32bit, 32> M;
      SecureBuffer<u32bit, 8> digest;
      const u32bit PASS;
   };

}

#endif

