/*************************************************
* ISAAC Header File                              *
* (C) 1999-2005 The Botan Project                *
*************************************************/

#ifndef BOTAN_ISAAC_H__
#define BOTAN_ISAAC_H__

#include <botan/base.h>

namespace Botan {

/*************************************************
* ISAAC                                          *
*************************************************/
class ISAAC : public StreamCipher
   {
   public:
      void clear() throw();
      std::string name() const { return "ISAAC"; }
      StreamCipher* clone() const { return new ISAAC; }
      ISAAC() : StreamCipher(1, 32) { clear(); }
      ~ISAAC() { clear(); }
   private:
      void cipher(const byte[], byte[], u32bit);
      void key(const byte[], u32bit);
      void generate();
      SecureBuffer<byte, 1024> buffer;
      SecureBuffer<u32bit, 256> state;
      u32bit A, B, C, position;
   };

}

#endif
