/*************************************************
* SEAL Header File                               *
* (C) 1999-2005 The Botan Project                *
*************************************************/

#ifndef BOTAN_SEAL_H__
#define BOTAN_SEAL_H__

#include <botan/base.h>

namespace Botan {

/*************************************************
* SEAL                                           *
*************************************************/
class SEAL : public StreamCipher
   {
   public:
      void seek(u32bit);
      u32bit start_position() const { return START; }
      void set_start_position(u32bit s) { START = s; }

      void clear() throw();
      std::string name() const;
      StreamCipher* clone() const;
      SEAL(u32bit);
   private:
      void cipher(const byte[], byte[], u32bit);
      void key(const byte[], u32bit);
      void generate(u32bit);
      u32bit START;
      SecureVector<byte> buf;
      SecureBuffer<u32bit, 512> T;
      SecureBuffer<u32bit, 256> S;
      SecureVector<u32bit> R;
      u32bit counter, position;
      };

/*************************************************
* SEAL Gamma Function                            *
*************************************************/
class Gamma
   {
   public:
      Gamma(const byte[20]);
      u32bit operator()(u32bit);
   private:
      SecureBuffer<u32bit, 5> K, digest;
      u32bit last_index;
   };

}

#endif
