/*************************************************
* POSIX Thread Mutex Header File                 *
* (C) 1999-2005 The Botan Project                *
*************************************************/

#ifndef BOTAN_EXT_MUTEX_PTHREAD_H__
#define BOTAN_EXT_MUTEX_PTHREAD_H__

#include <botan/mutex.h>

namespace Botan {

/*************************************************
* Pthread Mutex                                  *
*************************************************/
class Pthread_Mutex : public Mutex
   {
   public:
      void lock();
      void unlock();
      Mutex* clone() const { return new Pthread_Mutex; }

      Pthread_Mutex();
      ~Pthread_Mutex();
   private:
      struct mutex_wrapper* mutex;
   };

}

#endif
