// *************************************************************************
//
// Copyleft 2004-2007 Bruno PAGES  .
//
// This file is part of the BOUML Uml Contraintkit.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// e-mail : bouml@free.fr
// home   : http://bouml.free.fr
//
// *************************************************************************

#ifdef WIN32
#pragma warning (disable: 4150)
#endif

#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qcheckbox.h>

#include "ConstraintDialog.h"
#include "ConstraintCanvas.h"
#include "CdClassCanvas.h"
#include "BrowserNode.h"
#include "UmlPixmap.h"
#include "UmlDesktop.h"
#include "strutil.h"
#include "MyTable.h"

QSize ConstraintDialog::previous_size;

ConstraintDialog::ConstraintDialog(ConstraintCanvas * c)
    : QDialog(0, "ConstraintVisibilityDialog", TRUE, 0), constraint(c) {
  setCaption("Constraints visibility dialog");
  
  QVBoxLayout * vbox = new QVBoxLayout(this);  

  vbox->setMargin(5);
  
  QLabel * lbl = new QLabel("Click on V(isible) / H(idden) to change the constraint visibility",
			    this);
  lbl->setAlignment(Qt::AlignHCenter);
  vbox->addWidget(new QLabel(this));
  vbox->addWidget(lbl);
  vbox->addWidget(new QLabel(this));
  
  table = new ConstraintTable(this, constraint);
  vbox->addWidget(table);
  vbox->addWidget(new QLabel(this));
  
  QHBoxLayout * hbox;
  
  hbox = new QHBoxLayout(vbox);
  
  cb_visible = new QCheckBox("Specify visible elements rather than hidden ones", this);
  cb_visible->setChecked(constraint->indicate_visible);
  hbox->addWidget(cb_visible);
  
  QPushButton * showall = new QPushButton("Show all", this);
  QPushButton * hideall = new QPushButton("Hide all", this);
  QPushButton * hideinherited = new QPushButton("Hide inherited", this);
  QSize bs = hideinherited->sizeHint();

  showall->setFixedSize(bs);
  hideall->setFixedSize(bs);
  hideinherited->setFixedSize(bs);
  
  hbox->addWidget(new QLabel(this));
  hbox->addWidget(showall);
  hbox->addWidget(new QLabel(this));
  hbox->addWidget(hideall);
  hbox->addWidget(new QLabel(this));
  hbox->addWidget(hideinherited);
  hbox->addWidget(new QLabel(this));

  connect(showall, SIGNAL(clicked()), this, SLOT(show_all()));
  connect(hideall, SIGNAL(clicked()), this, SLOT(hide_all()));
  connect(hideinherited, SIGNAL(clicked()), this, SLOT(hide_inherited()));
  
  vbox->addWidget(new QLabel(this));
  hbox = new QHBoxLayout(vbox); 
  
  hbox->setMargin(5);
  QPushButton * ok = new QPushButton("&OK", this);
  QPushButton * cancel = new QPushButton("&Cancel", this);
  
  ok->setDefault( TRUE );
  bs = cancel->sizeHint();
  ok->setFixedSize(bs);
  cancel->setFixedSize(bs);
  
  hbox->addWidget(ok);
  hbox->addWidget(cancel);
    
  connect(ok, SIGNAL(clicked()), this, SLOT(accept()));
  connect(cancel, SIGNAL(clicked()), this, SLOT(reject()));  
}

ConstraintDialog::~ConstraintDialog() {
  previous_size = size();
}

void ConstraintDialog::polish() {
  static bool first = TRUE;
  
  QDialog::polish();
  if (first) {
    first = FALSE;

    QSize sz(width() * 2, height());
    
    resize(sz);
  }
  
  UmlDesktop::limitsize_center(this, previous_size, 0.9, 0.9);
}


void ConstraintDialog::show_all() {
  table->show_all();
}

void ConstraintDialog::hide_all() {
  table->hide_all();
}

void ConstraintDialog::hide_inherited() {
  table->hide_inherited(constraint);
}

void ConstraintDialog::accept() {
  constraint->indicate_visible = cb_visible->isChecked();
  table->update(constraint);
  
  QDialog::accept();
}

// ConstraintTable
//
// v/h, icon, name, constraint

ConstraintTable::ConstraintTable(QWidget * parent, ConstraintCanvas * c)
    : QTable(c->elements.count(), 4, parent) {  
  setSorting(FALSE);
  setSelectionMode(NoSelection);
  setRowMovingEnabled(FALSE);
  
  horizontalHeader()->setLabel(0, " ");
  horizontalHeader()->setLabel(1, " ");
  horizontalHeader()->setLabel(2, "element");
  horizontalHeader()->setLabel(3, "constraint");
  setColumnStretchable(0, FALSE);
  setColumnStretchable(1, FALSE);

  int row;
  bool v = c->indicate_visible;
  QValueList<BrowserNode *> & hv = c->hidden_visible;
  BrowserNodeList & elts = c->elements;
  BrowserNode * bn;

  elts.sort();

  for (bn = elts.first(), row = 0; bn != 0; bn = elts.next(), row += 1) {
    setText(row, 0, 
	    ((v) ? hv.findIndex(bn) != -1 : hv.findIndex(bn) == -1)
	    ? "V" : "H");
    
    setPixmap(row, 1, *(bn->pixmap(0)));
    
    TableItem * ti;
    
    ti = new TableItem(this, QTableItem::Never, bn->full_name(TRUE));
    ti->setReplaceable(FALSE);
    setItem(row, 2, ti);
    
    QString s = toUnicode(bn->constraint());
    int n = s.contains('\n');
    
    ti = new TableItem(this, QTableItem::Never, s);
    ti->setReplaceable(FALSE);
    setItem(row, 3, ti);
    if (n != 0) {
      // note : adjustRow(row) does nothing
      setRowHeight(row, rowHeight(row)*(n+1));
    }
  }
  
  adjustColumn(0);
  adjustColumn(1);
  setColumnStretchable (2, TRUE);
  setColumnStretchable (3, TRUE);
  
  connect(this, SIGNAL(pressed(int, int, int, const QPoint &)),
	  this, SLOT(button_pressed(int, int, int, const QPoint &)));
}

void ConstraintTable::button_pressed(int row, int col, int, const QPoint &) {
  if (col == 0)
    setText(row, col, (text(row, col) == "V") ? "H" : "V");
}

void ConstraintTable::show_all() {
  int row;
  
  for (row = 0; row != numRows(); row += 1)
    setText(row, 0, "V");
}

void ConstraintTable::hide_all() {
  int row;
  
  for (row = 0; row != numRows(); row += 1)
    setText(row, 0, "H");
}

void ConstraintTable::hide_inherited(ConstraintCanvas * c) {
  BrowserNode * cl = c->cl->get_bn();
  BrowserNodeList & elts = c->elements;  
  BrowserNode * bn;
  int row;

  for (bn = elts.first(), row = 0; bn != 0; bn = elts.next(), row += 1)
    setText(row, 0, 
	    ((bn == cl) || (bn->parent() == cl)) ? "V" : "H");
}

void ConstraintTable::update(ConstraintCanvas * c) {
  QValueList<BrowserNode *> & list = c->hidden_visible;  
  const char * condition = (c->indicate_visible) ? "V" : "H";
  BrowserNodeList & elts = c->elements;  
  BrowserNode * bn;
  int row;

  list.clear();
  
  for (bn = elts.first(), row = 0; bn != 0; bn = elts.next(), row += 1)
    if (text(row, 0) == condition)
      list.append(bn);
}
