#ifndef _HARMONY_H_
#define _HARMONY_H_

#include "globals.h"
#include "chord.h"



class HarmonyTrack;

/**
 * A Harmony declared with a base will be based on that base. The base always has the highest priority!?
 **/
class Harmony
{
 private:
  Key    _base_key; // base key: The Tonika, e.g. A - the base stays the same until a modulation is done!
  Genus  _base_gen; // the base key's genus, e.g. Major
  Key    _key;      // chord key, e.g. E (quint to A)
  Genus  _genus;    // chord genus, e.g Major
  int    _bass;     // base step of the chord, e.g. 7 for sept
  int    _bass_abs; // base step (Halbton), absolute (from "c" on), e.g. 7 for "g"
  // Bass e.g. H
  Chord  _chord;
  HarmonyTrack * _ht;
  int    _maj[12];
  int    _min[12];
  int    _dim[12];

 public:
  Harmony();
  Harmony(Key basekey, Genus basgenus);
  Harmony(Key basekey, Genus basgenus, Chord c);
  Harmony(Harmony h, Chord c, int stp=0);

  Key baseKey() const { return _base_key; }
  Genus baseGenus() const { return _base_gen; }

  Key key() const { return _key; }
  Genus genus() const { return _genus; }
  int bass() const { return _bass; }

  void analyse();
  void print();
};

#endif
