#ifndef _KDEHARMONYTRACK_CPP_
#define _KDEHARMONYTRACK_CPP_

#include <iostream.h>
#include <qpixmap.h>
#include <qcombobox.h>

#include "prMainEditor.h"

#include "riemann.h"
#include "harmonyTrack.h"
#include "kdeHarmonyTrack.h"

#include "kdeMainEditor.h"

extern PrMainEditor * mainEditor;

#define ME ((KdeMainEditor*)mainEditor)


static const char * harmonyIcon[]={
"22 22 3 1",
". c None",
"# c #000000",
"a c #ff0000",
"......................",
"......................",
"......................",
".....###.....###......",
"....#aaa#...#aaa#.....",
"...#aaaaa#.#aaaaa#....",
"...#aaaaa#.#aaaaa#....",
"..#aaaaaaa#aaaaaaa#...",
"..#aaaaaaaaaaaaaaa#...",
"..#aaaaaaaaaaaaaaa#...",
"..#aaaaaaaaaaaaaaa#...",
"..#aaaaaaaaaaaaaaa#...",
"...#aaaaaaaaaaaaa#....",
"...#aaaaaaaaaaaaa#....",
"....#aaaaaaaaaaa#.....",
"....#aaaaaaaaaaa#.....",
".....#aaaaaaaaa#......",
"......#aaaaaaa#.......",
".......##aaa##........",
".........###..........",
"......................",
"......................"};



KdeHarmonyTrack::KdeHarmonyTrack(Track * tr) : KdeTrack(tr) {
  
  _icon = new QPixmap(harmonyIcon);
  
  int hh = ME->trackHeight();
  QStrList * keylist = new QStrList(); for (int i=0; i<KEY; i++) keylist->append(sKey[i]);
  QStrList * genlist = new QStrList(); for (int i=0; i<GENUS; i++) genlist->append(sGenus[i]);
  
  _keybox = new QComboBox(FALSE,this,"key");
  _keybox->insertStrList( keylist );
  _keybox->setCurrentItem(((HarmonyTrack*)_track)->key());
  _keybox->setGeometry(168,0,160,hh+1);
  connect(_keybox,SIGNAL(highlighted(int)),SLOT(updateKey(int)));
  
  _genbox = new QComboBox(FALSE,this,"_output");
  _genbox->insertStrList( genlist );
  _genbox->setCurrentItem(((HarmonyTrack*)_track)->genus());
  _genbox->setGeometry(328,0,96,hh+1);
  connect(_genbox,SIGNAL(highlighted(int)),SLOT(updateGenus(int)));
  
  
  show();
}

void KdeHarmonyTrack::update(bool menu) {
  KdeTrack::update(menu);
}

void KdeHarmonyTrack::setKey(int k) {
  if (k>=0 && k<_keybox->count())
    _keybox->setCurrentItem(k);
}

void KdeHarmonyTrack::setGenus(int g) {
  if (g>=0 && g<_genbox->count())
    _genbox->setCurrentItem(g);
}

void KdeHarmonyTrack::updateKey(int n) {
  ((HarmonyTrack*)_track)->setKey((::Key) n);
}

void KdeHarmonyTrack::updateGenus(int n) {
  ((HarmonyTrack*)_track)->setGenus((Genus) n);
}



#endif
#include "kdeHarmonyTrack.moc"
