#ifndef _ADDELEMENT_H_
#define _ADDELEMENT_H_

#include "operation.h"

class Element;
class Compound;

/** This operation adds an element to a compound. In case the operation is undone, the element has to be deleted when the operation-instance is deleted.
 * For this reason, a _delete element is used...
 */
class AddElement : public Operation
{
 private:
  Element * _element;
  Compound * _list;
  Element * _delete;

 public:
  /** example:
   * new AddElement(new Note(), new Part());
   */
  AddElement(Element * e, Compound * list);
  AddElement(const AddElement&);
  ~AddElement();

  void undo();
  void redo();


  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
