#ifndef _ADDORNAMENT_H_
#define _ADDORNAMENT_H_

#include "operation.h"

class Ornament;
class Note;

/** This operation adds an ornament to a note. In case the operation is undone, the element has to be deleted when the operation-instance is deleted.
 * For this reason, a _delete element is used...
 */
class AddOrnament : public Operation
{
 private:
  Ornament * _ornament;
  Note * _note;
  Ornament * _delete;

 public:
  /** example:
   * new AddOrnament(new Expression(0), new Note());
   */
  AddOrnament(Ornament * o, Note * note);
  AddOrnament(const AddOrnament&);
  ~AddOrnament();

  void undo();
  void redo();


  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
