#ifndef _ADDTOSELECTION_H_
#define _ADDTOSELECTION_H_

#include "operation.h"

class Element;
class Compound;
class Reference;

/** This operation adds an element to a compound. In case the operation is undone, the element has to be deleted when the operation-instance is deleted.
 * For this reason, a _delete element is used...
 */
class AddToSelection : public Operation
{
 private:
  Reference * _ref;
  Reference * _delete;

 public:
  AddToSelection(Reference * ref);
  AddToSelection(const AddToSelection&);
  ~AddToSelection();

  void undo();
  void redo();


  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
