#ifndef _AUDIOEVENT_C_
#define _AUDIOEVENT_C_

#include <iostream.h>
#include <stdlib.h>
#include <string.h>

#include "audioEvent.h"
#include "loader.h"
#include "table.h"
#include "str.h"

AudioEvent::AudioEvent( ) : Event(0,0), _filename(0) { _type = AUDIOEVENT; }

AudioEvent::AudioEvent( Position p, long len, const char * name ) : Event(p,len), _filename(name) { _type = AUDIOEVENT; }


const char * AudioEvent::fileName() { return _filename; }

const char * AudioEvent::name() {
  char * ptr = (char*) _filename;
  if (_filename!=0) {
    for (ptr += strlen(_filename); ptr>_filename && ptr[0]!='/'; ptr--) {}
    if (ptr[0]=='/') ptr++;
  }
  return ptr;
}

void AudioEvent::setFileName(const char * name) {
  // if (_filename) delete[] _filename;
  // filename = (char*) strdup(name);
  _filename = name;
}




ostream & AudioEvent::print(int dep, ostream & s) const {
  s << spc(dep) << "<AUDIOEVENT pos=\"" << internalStart().ticks() << "\" len=\"" << duration() << "\" file=\"" << _filename << "\" />" << endl;
  return s;
}

void AudioEvent::flush(const char * c) const {
  cout << c << "AUDIOEVENT at " << internalStart().bar() << "." << internalStart().beat() << "." << internalStart().tick() << endl;
}

Element * AudioEvent::copy() const {
  return new AudioEvent(internalStart(),duration(),_filename);
}



Element * AudioEvent::load(char * aline, ifstream *& , Element * ) { // inPtr, parent
  AudioEvent * ae = new AudioEvent();
  Table * attr = Loader::getAttributes("AUDIOEVENT",aline);
  if (attr!=0) {
    
    long llen = 0;
    long pos = 0;
    const char * nam;
    
    if (attr->getEntry("pos")) pos = atol(((String*) attr->getEntry("pos"))->getValue());
    if (attr->getEntry("len")) llen = atol(((String*) attr->getEntry("len"))->getValue());
    if (attr->getEntry("file")) nam = ((String*) attr->getEntry("file"))->getValue();
    
    ae->setFileName(nam);
    ae->setInternalStart(pos);
    ae->setDuration(llen);
    
    attr->scratch();
    delete attr;
  }
  return ae;
}


#endif
