#ifndef _BOW_CPP_
#define _BOW_CPP_

#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#include "bow.h"
#include "loader.h"
#include "table.h"
#include "str.h"

Bow::Bow() : _length(0), _direction(0), _delta(0) { _type = BOW; }

Bow::Bow(int l) : _length(l), _direction(0), _delta(0) { _type = BOW; }

Bow::Bow(int l, int d) : _length(l), _direction(d), _delta(0) { _type = BOW; }

Bow::Bow(int l, int d, int dd) : _length(l), _direction(d), _delta(dd) { _type = BOW; }

Bow::Bow(const Bow& o) : Ornament(o) {
  _type = BOW;
  _length = o._length;
  _direction = o._direction;
  _delta = o._delta;
}

void Bow::flip() {
  if (_direction==UP) _direction = DOWN;
  else _direction = UP;
}

void Bow::setLength(int l) { _length = l; }

void Bow::setDirection(int d) { _direction = d; }

void Bow::setUp() { _direction = UP; }

void Bow::setDown() { _direction = DOWN; }

void Bow::setDelta(int d) { _delta = d; }




// virtuals:


ostream & Bow::print(int dep, ostream & s) const {
  s << spc(dep) << "<BOW length=\"" << _length << "\" direction=\"";
  switch (_direction) {
  case UP: s << "UP"; break;
  case DOWN: s << "DOWN"; break;
  }
  s << "\" delta=\"" << _delta << "\" />" << endl;
  return s;
}

void Bow::flush(const char * c) const {
  cout << c << "BOW " << _length << ", " << _direction << ", " << _delta << endl;

}

Element * Bow::copy() const {
  return new Bow(*this);
}

Element * Bow::load(char * aline, ifstream *&, Element * ) { // inPtr, parent
  Bow * bow = new Bow();

  Table * attr = Loader::getAttributes("BOW",aline);
  if (attr!=0) {
    bow->setLength( atoi(((String*) attr->getEntry("length"))->getValue()) );
    bow->setDelta( atoi(((String*) attr->getEntry("delta"))->getValue()) );
    const char * dirname = ((String*) attr->getEntry("direction"))->getValue();
    if (dirname!=0 && strcmp(dirname,"DOWN")==0) bow->setDown(); else bow->setUp();

    attr->scratch();
    delete attr;
  }
  return bow;
}


#endif
