#ifndef _COPYPART_H_
#define _COPYPART_H_

#include "operation.h"
#include "position.h"

class Element;
class Compound;
class Track;
class Part;

/** This operation copies a part to the position p
 */
class CopyPart : public Operation
{
 private:
  Part * _part;
  Track * _src;
  Track * _tgt;
  Position _old;
  Position _new;

 public:
  CopyPart(Position p, Part * pt, Track * src, Track * tgt);
  CopyPart(const CopyPart&);
  ~CopyPart();

  void undo();
  void redo();


  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
