#ifndef _EVENT_CPP_
#define _EVENT_CPP_

#include "event.h"

Event::Event() : _pos(0), _duration(0) { _type = EVENT; }

Event::Event(const Event& e) : Atoma(e), _pos(0), _duration(0) {
  _type = EVENT;
  _pos = e.internalStart().ticks();
  _duration = e.duration();
}

Event::Event(Position p) : _pos(p), _duration(0) { _type = EVENT; }

Event::Event(Position p, long l) : _pos(p), _duration(l) { _type = EVENT; }


long Event::internalEnd() const {
  long x = _pos.ticks();
  x += _duration;
  return x;
}

void Event::setInternalStart(Position pos) {
  _pos = pos;
}

void Event::snapStart(int i) {
  _pos.snap(i);
}

void Event::setDuration(long l) {
  _duration = l;
}

const char * Event::value() {
  return 0;
}

/*
bool Event::startsBefore(long l) {
  return (_pos.ticks()<l);
}

bool Event::startsBehind(long l) {
  return (_pos.ticks()>l);
}

bool Event::startsAt(long l) {
  return (_pos.ticks()==l);
}

bool Event::endsBefore(long l) {
  return (_pos.ticks()+_len<l);
}

bool Event::endsBehind(long l) {
  return (_pos.ticks()+_len>l);
}

bool Event::endsAt(long l) {
  return (_pos.ticks()+_len==l);
}
*/

#endif
