#ifndef _PASTESELECTION_CPP_
#define _PASTESELECTION_CPP_

#include <iostream.h>

#include "pasteSelection.h"
#include "element.h"
#include "compound.h"

#include "track.h"
#include "event.h"
#include "song.h"
#include "part.h"
#include "table.h"
#include "reference.h"

extern Song * sonG;
extern Table * selectionMemory;


PasteSelection::PasteSelection(Compound * pt, long pos) : _ins(new Table()), _comp(pt), _pos(pos) {
  _type = PASTESELECTION;
  _description = "paste selection";
  _to_be_undone = true;

  Element * ev = 0;
  long dpos = 0;
  Reference * fst = (Reference*) selectionMemory->first();
  if (fst!=0) {
    if (fst->getValue()->isEvent())   dpos = ((Event*) fst->getValue())->internalStart() - _pos;
    if (fst->getValue()->isA()==PART) dpos = ((Part*) fst->getValue())->start() - _pos;
  }
  for (Reference * r = (Reference*)selectionMemory->first(); r != 0; r = (Reference*) Element::next(r)) {
    ev = r->getValue()->copy();
    if (dpos != 0) {
      if (ev->isEvent())   ((Part*)_comp)->setStart( (Event*)ev ,((Event*)ev)->internalStart() - dpos );
      if (ev->isA()==PART) ((Part*)ev)->setStart(((Part*)ev)->start() - dpos);
    }
    _ins->add(new Reference(ev));
    _comp->add(ev);
    if (_comp->isTrack() && ev->isA()==PART) ((Part*)ev)->setTrack((Track*)_comp);
    if (ev->isTrack()) for (Part * pt = (Part*) ((Track*)ev)->first(); pt!=0; pt = (Part*) ((Track*)ev)->next(pt)) pt->setTrack((Track*)ev);
  }
  if (fst->getValue()->isA()==PART) ((Part*)fst->getValue())->reorder();
  sonG->updateGui();
}


PasteSelection::PasteSelection(const PasteSelection& el) : Operation(el) {
  _type = PASTESELECTION;
  _comp = el._comp;
  _pos  = el._pos;
}

PasteSelection::~PasteSelection() {
  if (_ins!=0) {
    ((Compound*)_ins)->scratch(); // ??? doesn't he take the table's scratch-method ???
    delete _ins;
  }
}

void PasteSelection::undo() {
  for (Reference * r = (Reference*)_ins->first(); r != 0; r = (Reference*) Element::next(r)) {
    _comp->remove((Element*) r->getValue());
    r->getValue()->hide();
  }
}

void PasteSelection::redo() {
  for (Reference * r = (Reference*)_ins->first(); r != 0; r = (Reference*) Element::next(r)) {
    _comp->add((Element*) r->getValue());
    r->getValue()->show();
  }
}



// ---------------
// virtuals:
//

ostream & PasteSelection::print(int dep, ostream & s) const {
  s << spc(dep) << "<PASTESELECTION />" << endl;
  return s;
}

void PasteSelection::flush(const char * c) const {
  cout << c << "PASTESELECTION" << endl;
}

Element * PasteSelection::copy() const {
  return new PasteSelection(*this);
}




#endif
