#ifndef _PRFACTORY_H_
#define _PRFACTORY_H_

class PrMainEditor;
class PrTrack;
class PrPart;
class Track;
class Part;
class PrScorePainter;
class ScorePrinter;

enum PresentationType { TEXT, KDE };

class PrFactory
{
 private:
  static PrFactory * _factory;

 protected:
  static PrScorePainter * scorePainter;
  static ScorePrinter * scorePrinter;

 public:
  PrFactory();
  virtual ~PrFactory();
  static void setFactory(PrFactory*);
  static PrFactory * factory();

  ScorePrinter * getScorePrinter();

  virtual PresentationType isA() const = 0;
  virtual PrMainEditor * createMainEditor(int,char**)=0;
  virtual PrTrack * createScoreTrack(Track*)=0;
  virtual PrTrack * createDrumTrack(Track*)=0;
  virtual PrTrack * createMasterTrack(Track*)=0;
  virtual PrTrack * createAudioTrack(Track*)=0;
  virtual PrTrack * createCommentTrack(Track*)=0;
  virtual PrPart  * createPart(Part*)=0;
  virtual PrScorePainter * getScorePainter()=0;
};


#endif
