#ifndef _REFERENCE_CPP_
#define _REFERENCE_CPP_

#include <iostream.h>
#include <string.h>

#include "reference.h"

Reference::Reference() : _key(0), _value(0) {
  _type = REFERENCE;
}

Reference::Reference(const Reference& e) : Atoma(e,REFERENCE) {
  const char * x = e.getKey();
  if (x!=0) _key = strdup(x); else _key = 0;
  _value = e.getValue();
}

Reference::Reference(Element * e) : _key(0), _value(e) {
  _type = REFERENCE;
}

Reference::Reference(const char * k, Element * e) : _key(k), _value(e) {
  _type = REFERENCE;
}

Reference::~Reference() {
  //if (_key!=0) delete[] _key;
}

Element * Reference::getValue(const char * k) const {
  Element * retv = 0;
  if ((k!=0)&&(_key!=0))
    if (strcmp(k,_key)==0) retv = _value;
  return retv;
}




ostream & Reference::print(int dep, ostream & s) const {
  s << spc(dep) << "<REFERENCE";
  if (_key!=0) s << " key=\"" << _key << "\"";
  s << " value=\"" << *_value << "\" />" << endl;
  return s;
}

void Reference::flush(const char * c) const {
  cout << c << "REFERENCE " << _value << endl;

}

Element * Reference::copy() const {
  return new Reference(*this);
}


#endif
