#ifndef _REMOVEORNAMENT_H_
#define _REMOVEORNAMENT_H_

#include "operation.h"

class Vector;
class Note;

/** This operation removes ornament from a note. (The ornaments are not removed until the RemoveOrnament object is deleted!)
 */
class RemoveOrnament : public Operation
{
 private:
  Note   * _note;
  Type     _ornament_type;
  Vector * _hidden;

 public:
  /** example:
   * new RemoveOrnament(note, BOW);
   */
  RemoveOrnament(Note * note, Type t);
  RemoveOrnament(const RemoveOrnament&);
  ~RemoveOrnament();

  void undo();
  void redo();


  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
