#ifndef _SCORECHORD_H_
#define _SCORECHORD_H_

#include "scoreElement.h"
#include "position.h"
#include "table.h"

class Note;
class Reference;
class PrScoreEditor;

class ScoreChord : public ScoreElement
{
 private:
  Table   _notes;

 public:
  ScoreChord();
  virtual ~ScoreChord();
  virtual void add(Note * note, Position pos, long dur, int dis, bool _no_overlap);

  virtual bool isBreak() const;
  virtual bool isChord() const;
  virtual bool hasNoFlags() const;
  virtual void paint(PrScoreEditor * ed, int x=0, int y=0, int style=0);
  virtual void print(PrScoreEditor * ed, int x=0, int y=0);

  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};

#endif

