#ifndef _SELECTIONITERATOR_H_
#define _SELECTIONITERATOR_H_

#include "compound.h"
#include "position.h"

class Table;
class Reference;
class Event;
class PrPartEditor;

class SelectionIterator {
 private:
  Table   * _table;
  Reference * _ref;
  Event   * _event;

 public:
  SelectionIterator(const SelectionIterator & i);
  
  SelectionIterator(Table * table = 0);
  
  bool operator!=(const SelectionIterator & i) const;
  
  bool operator==(const SelectionIterator & i) const;
  
  bool done();
  
  Position start();
  
  Element * operator *();
  
  SelectionIterator& operator++();
  
  SelectionIterator operator++(int);
};

#endif
