#ifndef _SONG_CPP_
#define _SONG_CPP_

#include <stdlib.h>
#include <iostream.h>
#include <stdio.h>
#include <string.h>
#include <fstream.h>
#include <math.h>

#include "song.h"
#include "table.h"
#include "str.h"
#include "loader.h"
#include "player.h"
#include "prProgress.h"
#include "prMainEditor.h"

#include "scoreTrack.h"
#include "drumTrack.h"
#include "audioTrack.h"
#include "masterTrack.h"
#include "commentTrack.h"

#ifdef HAVE_ARTS_ENVIRONMENT
#include "soundserver.h"
using namespace Arts::Environment;
using namespace std;
#endif

extern char * getcmd(char*);
extern PrMainEditor * mainEditor;
extern Table * selectioN;
extern Table * selectionMemory;
extern Song * sonG;
extern int output;

void Song::initEnvironment() {
#ifdef HAVE_ARTS_ENVIRONMENT
  if (output==ARTS) {
    _arts_container = Container::null();
    _arts_mixer = MixerItem::null();
    Arts::SoundServer server = Arts::Reference("global:Arts_SoundServer");
    if (server.isNull()) {
      cout << "SoundServer is null" << endl;
    } else {
      _arts_container = Arts::DynamicCast(server.createObject("Arts::Environment::Container"));
      if (_arts_container.isNull()) {
	cout << "ArtsContainer is null" << endl;
      } else {
	_arts_mixer = Arts::DynamicCast(_arts_container.createItem("Arts::Environment::MixerItem"));
      }
    }
  }
#endif
}

Song::Song()
  : _title("untitled"), _author("-"), _comment("-"), _tempo(120), _meter0(4), _meter1(4), _left((long)0), _right((long)12288), _current(0), _master(0), _version(0),
    _part_appearance(TRACKNAME), _editor_appearance(NOADJUST)
{
  _type = SONG;
  _player = new Player(this);
  sonG = this;
  initEnvironment();
}

Song::Song(double v)
  : _title("untitled"), _author("-"), _comment("-"), _tempo(120), _meter0(4), _meter1(4), _left((long)0), _right((long)12288), _current(0), _master(0), _version(v),
    _part_appearance(TRACKNAME), _editor_appearance(NOADJUST)
{
  _type = SONG;
  _player = new Player(this);
  sonG = this;
  initEnvironment();
}

Song::Song(const Song& e)
  : Compound(e,SONG), _title("untitled"), _author("-"), _comment("-"), _tempo(120), _meter0(4), _meter1(4), _left((long)0), _right((long)12288), _current(0), _master(0),
    _part_appearance(TRACKNAME), _editor_appearance(NOADJUST)
{
  _title = strdup(e.title());
  _author = strdup(e.author());
  _comment = strdup(e.comment());
  _tempo = e.tempo();
  _meter0 = e.meter0();
  _meter1 = e.meter1();
  _left = e.left();
  _right = e.right();
  _current = e.current();
  _version = e.version();
  if (e.master()!=0) _master = (Part*) e.master()->copy();
  _player = new Player(this);
  sonG = this;
  // initEnvironment(); // TODO: change this to a real copy!
#ifdef HAVE_ARTS_ENVIRONMENT
  if (output==ARTS) {
    //
    // only works, if the song contains exactly one mixer!!!
    //
    vector<string> * data = e._arts_container.saveToList();
    _arts_container = Container::null();
    _arts_mixer = MixerItem::null();
    Arts::SoundServer server = Arts::Reference("global:Arts_SoundServer");
    if (server.isNull()) {
      cout << "SoundServer is null" << endl;
    } else {
      _arts_container = Arts::DynamicCast(server.createObject("Arts::Environment::Container"));
      if (_arts_container.isNull()) {
	cout << "Container is null" << endl;
      } else {
	_arts_container.loadFromList(*data);
	vector<Item> * items = _arts_container.items();
	for (vector<Item>::iterator i = items->begin(); i != items->end(); i++)
	  if (i->_interfaceName()=="Arts::Environment::MixerItem")
	    _arts_mixer = Arts::DynamicCast(*i);
	delete items;
      }
    }
    delete data;
  }
#endif
}

Song::~Song() { delete _player; }

void Song::updateGui(int changes) {
  if (changes!=-1) mainEditor->gui(CHANGES,changes);
  if (opHistory.empty()) mainEditor->ui(UNDO,false);
  else                   mainEditor->ui(UNDO,true);
  if (opFuture.empty()) mainEditor->ui(REDO,false);
  else                  mainEditor->ui(REDO,true);
  if (selectioN->empty()) mainEditor->ui(SELECTIONS,false);
  else                    mainEditor->ui(SELECTIONS,true);
  if (selectionMemory->empty()) mainEditor->ui(MEMORY,false);
  else                          mainEditor->ui(MEMORY,true);
  mainEditor->ui(); // updates content!
}

void Song::doo(Operation * op) {
  if (op->isToBeUndone()) {

    opHistory.add(op);
    if (opFuture.size()>0) {
      opFuture.scratch();
    }
    if (opHistory.size() > mainEditor->undoMemory()) {
      Operation * del = (Operation*) opHistory.cutFirst();
      delete del;
    }
    updateGui(true);
  } else {
    updateGui();
    delete op;
  }
}

void Song::undo(int k) {
  int i = (k==-1) ? 0 : k;
  for (;i>=0;i--) {
    if (!opHistory.empty()) {
      Operation * op = (Operation*) opHistory.cutLast();
      op->undo();
      opFuture.push(op);
    }
  }
  if (k==-1) updateGui(true);
}

void Song::redo(int k) {
  int i = (k==-1) ? 0 : k;
  for (;i>=0;i--) {
    if (!opFuture.empty()) {
      Operation * op = (Operation*) opFuture.cutFirst();
      op->redo();
      opHistory.add(op);
    }
  }
  if (k==-1) updateGui(true);
  // if (k==-1) if (opFuture.empty()) mainEditor->gui(REDO,false);
}

Vector * Song::undoList() { return &opHistory; }

Vector * Song::redoList() { return &opFuture; }

void Song::oplist() {
  cout << "History:\n" << opHistory << endl;
  cout << "Future:\n" << opFuture << endl;
}

void Song::clearOplist() {
  opHistory.scratch();
  opFuture.scratch();
  updateGui();
}

Operation * Song::currentOp() {
  return (Operation*) opHistory.last();
}

const char * Song::currentUndoText() {
  Operation * op = (Operation*) opHistory.last();
  if (op!=0) return op->description();
  else return " ";
}

const char * Song::currentRedoText() {
  Operation * op = (Operation*) opFuture.first();
  if (op!=0) return op->description();
  else return "-";

}

void Song::setTitle(const char * t) { _title = t; } // TODO: delete _title ????

void Song::setAuthor(const char * a) { _author = a; }

void Song::setComment(const char * c) { _comment = c; }

void Song::setPartAppearance(PartApp i) { _part_appearance = i; }

void Song::setEditorAppearance(EditorApp i) { _editor_appearance = i; }

void Song::setTempo(int t) { _tempo = t; _player->setTempo(t); }

void Song::setMeter(int m0, int m1) { setMeter0(m0); setMeter1(m1); }

void Song::setMeter0(int m0) { _meter0 = m0; }

void Song::setMeter1(int m1) { _meter1 = m1; }

void Song::setLeft(Position p) { _left = p; }

void Song::setLeft(int a, int b, int c) {
  _left.set(a,b,c,_master,_meter0,_meter1);
}

void Song::setRight(Position p) { _right = p; }

void Song::setRight(int a, int b, int c) {
  _right.set(a,b,c,_master,_meter0,_meter1);
}

void Song::setCurrent(Position p) { _current = p; }

void Song::setCurrent(int a, int b, int c) {
  _current.set(a,b,c,_master,_meter0,_meter1);
}

void Song::setMaster(Part * pt) { _master = pt; cout << "*******# " << pt << endl; }


void Song::bbt(int & bar, int & beat, int & tick, Position pos) {
  // int i = int(pow(2,_meter1));
  pos.gBBT(bar,beat,tick,_master,_meter0,_meter1);
}

void Song::play(PrProgress * progress, Part * part, long left, long right, bool cycl, int record_track) {
  _player->play(progress,part,left,right,cycl, record_track);
}

bool Song::hasScore() {
  bool ret = false;
  for (Track * tr = (Track*) sonG->first(); tr != 0; tr = (Track*) sonG->next(tr)) {
    if (tr->isA()==SCORETRACK && tr->first()!=0) ret = true;
  }
  return ret;
}

bool Song::hasDrum() {
  bool ret = false;
  for (Track * tr = (Track*) sonG->first(); tr != 0; tr = (Track*) sonG->next(tr)) {
    if (tr->isA()==DRUMTRACK && tr->first()!=0) ret = true;
  }
  return ret;
}

Track * Song::createTrack(int type, const char * desc) {
  Track * tr = 0;
  switch (type) {
  case 0: tr = new ScoreTrack(); break; // tr->loadOpt(inPtr); break;
  case 1: tr = new DrumTrack(); break; // tr->loadOpt(inPtr); break;
  case 2: tr = new MasterTrack(); break; // tr->loadOpt(inPtr); break;
  case 3: tr = new AudioTrack(); break; // tr->loadOpt(inPtr); break;
  case 4: tr = new CommentTrack(); break; // tr->loadOpt(inPtr); break;
  default: tr = mainEditor->createAddonTrack(desc);
  }
  return tr;
}

Track * Song::getTrack(const char * desc) {
  Track * tr = 0;
  if (desc!=0)
    for (Track * t = (Track*) sonG->first(); t!=0 && tr==0; t = (Track*) sonG->next(t)) {
      if (strcmp(t->ctype(), desc)==0) tr = t;
    }
  return tr;
}

ostream & Song::print(int dep, ostream & s) const {
  s << spc(dep) << "<SONG>" << endl;
  s << spc(dep) << "<HEAD title=\"" << _title << "\" author=\"" << _author << "\" comment=\"" << _comment << "\" ";
  s << "tempo=\"" << _tempo << "\" meter0=\"" << _meter0 << "\" meter1=\"" << _meter1 << "\" ";
  s << "left=\"" << _left.ticks() << "\" right=\"" << _right.ticks() << "\" tracks=\"" << size() << "\" />" << endl;
  printContent(dep,s);
  s << spc(dep) << "</SONG>" << endl;
#ifdef HAVE_ARTS_ENVIRONMENT
  s << spc(dep) << "<ENVIRONMENT>" << endl;
  vector<string> * data = _arts_container.saveToList();
  for (vector<string>::iterator i = data->begin(); i != data->end(); i++)
    s << *i << endl;
  s << "</ENVIRONMENT>" << endl;
#endif
  return s;
}

void Song::flush(const char * c) const {
  cout << c << "SONG" << endl;
}


Element * Song::copy() const {
  Song * sng = new Song(*this);
  return sng;
}


Element * Song::load(ifstream * inPtr, double version, PrProgress * progress) {
  Song * song = new Song(version);
  if (version>=98.0) {
    Table * attr = Loader::getAttributes("SONG",inPtr);
    attr->scratch();
    delete attr;
  }
  Table * head = Loader::getAttributes("HEAD",inPtr);
  int num = 0;
  if (head) {
    String * val = 0;
    val = (String*) head->getEntry("tempo"); if (val) song->setTempo( atoi(val->getValue()) );
    val = (String*) head->getEntry("title"); if (val) song->setTitle( strdup(val->getValue()) );
    val = (String*) head->getEntry("comment"); if (val) song->setComment( strdup(val->getValue()) );
    val = (String*) head->getEntry("author"); if (val) song->setAuthor( strdup(val->getValue()) );
    val = (String*) head->getEntry("left"); if (val) song->setLeft( Position(atoi(val->getValue())) );
    val = (String*) head->getEntry("right"); if (val) song->setRight( Position(atoi(val->getValue())) );
    val = (String*) head->getEntry("meter0"); if (val) song->setMeter0( atoi(val->getValue()) );
    val = (String*) head->getEntry("meter1"); if (val) song->setMeter1( atoi(val->getValue()) );
    val = (String*) head->getEntry("tracks"); if (val) num = atoi(val->getValue());

    head->scratch();
    delete head;
  }
  if (version>=98.0) {
    Element::loadContent(song,"/SONG","TRACK",&Track::load,inPtr,progress,num);
#ifdef HAVE_ARTS_ENVIRONMENT
    ifstream &in = *inPtr;
    char * line = new char[401];
    char * ptr = line;
    line[0] = 0;
    bool ok = 1;
    int count = 0;
    while ((ok==1)&&(strncmp(ptr,"</ENVIRONMENT>",14)!=0)) {
      ok = in.getline(line,400,'\n');
      if ( (ok!=0) && (strncmp(ptr,"</ENVIRONMENT>",14)!=0) && (count++>0) )
	cout << "*" << line << "*" << endl;
    }
#endif
  } else {
    song->setMeter1(pow(2,song->meter1()));
    Element::loadContent(song,"/DOCUMENT","TRACK",&Track::load,inPtr,progress,num);
  }
  return song;
}

void Song::add(Element * e) {
  Compound::add(e);
#ifdef HAVE_ARTS_ENVIRONMENT
  if (output==ARTS) {
    int num = size(); // TODO: num = only mixable tracks!
    _arts_mixer.channelCount(num);
    Track * tr = (Track*) e;
    char buf[100];
    sprintf(buf, "%s%02d", _arts_mixer.name().c_str(), num);
    tr->envInstrument().busname(buf);
  }
#endif
}

#endif
