#ifndef _TABLE_CPP_
#define _TABLE_CPP_

#include <iostream.h>
#include <string.h>
#include "table.h"
#include "str.h"
#include "reference.h"

Table::Table() {
  _type = TABLE;
}

Table::Table(const Table& e) : Compound(e,TABLE) {
  _type = TABLE;
}


Element * Table::operator[](Element * s) {
  Element * retv = 0;
  cout << "not implemented yet" << s << endl;
  return retv;
}


Element * Table::getEntry(const char * k) {
  Element * retv = 0;
  for (Element * foo = first(); foo != 0; foo = Element::next(foo)) {
    if (foo->isA()==REFERENCE)
      if (((Reference*)foo)->getValue(k)!=0)
	retv = ((Reference*)foo)->getValue(k);
  }
  return retv;
}


void Table::removeEntry(Element * e) {
  Reference * rem = 0;
  for (Element * foo = first(); foo != 0; foo = Element::next(foo)) {
    if (foo->isA()==REFERENCE)
      if (((Reference*)foo)->getValue()==e)
	rem = (Reference*) foo;
  }
  if (rem!=0) remove(rem);
  delete rem;
}

void Table::deleteEntry(Element * e) {
  Reference * rem = 0;
  for (Element * foo = first(); foo != 0; foo = Element::next(foo)) {
    if (foo->isA()==REFERENCE)
      if (((Reference*)foo)->getValue()==e)
	rem = (Reference*) foo;
  }
  if (rem!=0) remove(rem);
  if (rem->getKey() != 0) delete rem->getKey();
  if (rem->getValue() != 0) delete rem->getValue();
  delete rem;
}

bool Table::hasEntry(Element * e) {
  bool ret = false;
  for (Element * foo = first(); foo != 0; foo = Element::next(foo)) {
    if (foo->isA()==REFERENCE)
      if (((Reference*)foo)->getValue()==e)
	ret = true;
  }
  return ret;
}

#define OUT(X) //
// cout << "* " << X << endl

void Table::scratch() {
  // cout << "Table::scratch() in" << endl;
  Element * bar = 0;
  for (Element * foo = first(); foo != 0; ) {
    if (foo->isA()==REFERENCE) {
      OUT(1);
      if (((Reference*)foo)->getKey()!=0) delete ((Reference*)foo)->getKey();
      OUT(2);
      if (((Reference*)foo)->getValue()!=0) delete ((Reference*)foo)->getValue();
      OUT(3);
      bar = foo;
      OUT(4);
      foo = Element::next(foo);
      OUT(5);
      remove(bar);
      OUT(6);
      delete bar;
      OUT(7);
    }
  }
  // cout << "Table::scratch() out" << endl;
}




ostream & Table::print(int dep, ostream & s) const {
  s << spc(dep) << "<TABLE>" << endl;
  printContent(dep,s);
  s << spc(dep) << "</TABLE>" << endl;
  return s;
}

void Table::flush(const char * c) const {
  cout << c << "TABLE " << size() << endl;
}

Element * Table::copy() const {
  return new Table(*this);
}

#endif
