#ifndef _SCOREITERATOR_CPP_
#define _SCOREITERATOR_CPP_

#include "scoreIterator.h"
#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include <string.h>
#include "track.h"
#include "part.h"
#include "event.h"
#include "note.h"
#include "prPartEditor.h"
#include "scoreBar.h"


struct InitState {
  Position cur_pos;
  Position free_pos;
  Position next_bar;
  ScoreBar * bar;
};


ScoreIterator::ScoreIterator(const ScoreIterator & i) : _score(i._score), _res(i._res), _no_overlap(i._no_overlap) { cout << "+++" << endl; }

ScoreIterator::ScoreIterator(Track * tr) : _part((Part*)tr->first()), _systems(1), _res(0), _width(0) {
  _iterator = new (Iterator*)[_systems];
  _iterator[0] = new Iterator(tr);
  _score = new Table[_systems];
  init();
}

ScoreIterator::ScoreIterator(Part * pt, Position left, Position right) : _part(pt), _systems(1), _res(0), _no_overlap(0), _width(0) {
  _iterator = new (Iterator*)[_systems];
  _iterator[0] = new Iterator(pt, left, right);
  _score = new Table[_systems];
  init();
}

ScoreIterator::ScoreIterator(PrPartEditor * editor) : _part(editor->part(0)), _systems(editor->parts()), _res(editor->resolution()),
						      _no_overlap(editor->noOverlap()), _width(editor->editorWidth()) {
  _iterator = new (Iterator*)[_systems];
  for (int i=0; i<_systems; i++) {
    _iterator[i] = new Iterator(editor);
  }
  _score = new Table[_systems];
  init();
}

ScoreIterator::~ScoreIterator() {
  delete state;
  for (int i=0; i<_systems; i++) {
    delete _iterator[i];
  }
  delete[] _iterator;
  delete[] _score;
}

void ScoreIterator::add(int sys, Note * note, long len, Position pos) {
  // if no position specified, take free_pos:
  if (pos==0) pos = state->free_pos;

  // if no length specified, take nextbar-curpos:
  if (len==0) len = state->next_bar - state->free_pos.ticks();

  if (len>0 && pos < _right) { // only for lenghts!=0 and inside the range!
    // cout << "add " << note << " at " << pos << " - " << len << endl;
    if (state->bar==0) {
      state->bar = new ScoreBar(Iterator::change());
      state->bar->add(note, pos, len, _no_overlap);
      _score[sys].add(state->bar);
    } else {
      state->bar->add(note, pos, len, _no_overlap);
    }
    Position foo = pos+len;
    if (foo > state->free_pos) state->free_pos = foo;
    state->cur_pos = pos;
  }
}


void ScoreIterator::nextbar() {
  state->cur_pos.nextBar();
  state->next_bar.nextBar();
  state->free_pos = state->cur_pos;
  state->bar = 0;
}

void ScoreIterator::init() {
  //
  // init
  //
  _max = 0;
  for (int sys = 0; sys < _systems; sys++) {

    Note * note = 0;
    Part * pt = 0;
    Event * event = 0;
    Position notepos = 0;
    long     noteend = 0;
    long         brk = 0;
    bool      adjust = false;
    state = new InitState;
    state->cur_pos  = _left;
    state->free_pos = _left;
    state->next_bar = _left;
    state->next_bar.nextBar();
    state->bar = 0;

    for (; !reallyDone(sys); _iterator[sys]->operator++()) {
      pt = _iterator[sys]->change();
      if (pt!=0) _part = pt;

      event = _iterator[sys]->operator*();
      if ( event->isA() == NOTE ) {

	note = (Note*) event;
	notepos = _part->start(note);
	if (_res) adjust = (note->tuplet()==0);
      
	if (adjust) notepos.snap(_res);
	
	noteend = truncEnd(note);
	
	if (adjust) {
	  noteend += int(_res*0.49);
	  noteend -= (noteend%_res);
	}

	while ( !state->cur_pos.sameBarOrGreater(notepos) ) { // while bar(curpos) < bar(note)
	  add(0); // 0 means break
	  nextbar();
	}
	if (notepos < state->free_pos) {
	  //
	  // in case the new note starts before the previous note ends:
	  //
	  state->free_pos = notepos;
	} else {
	  //
	  // freepos is, where the previous note ends:
	  //
	  brk = notepos - state->free_pos.ticks();
	  if (brk<0)          cout << "ScoreIterator::PANIC " << brk << " = " << notepos << " - " << state->free_pos << endl;
	  else if (brk > 0)   add(0, brk);
	}
	
	while ( noteend > state->next_bar ) {
	  add(note);
	  nextbar();
	}
	long len = noteend - state->free_pos.ticks();
	if (len>0) add(note, len);
	
      }
    }
    
    if (_score[sys].size()>max) _max = _score[sys].size();
  }
  _ptr = 0;
  //
  // To calculate the scaling coefficient: SUM over bars: [ c*len(bar) + indent(bar)] = width
  //
  int width = _width;
  int sum = 0;
  int wd = 0;
  for (int i=0; i<_max; i++) {
    for (int sys = 0; sys < _systems; sys++) {
      
    }
  }
  /* for (ScoreBar * b = (ScoreBar*) _score.first(); b!=0; b = (ScoreBar*) _score.next(b)) {
     width -= b->indent();
     sum += b->rawWidth();
     }*/
  //
  // now: c * sum = width => c = width/sum
  //
  _scale = width*1.0/sum;
  for (ScoreBar * b = (ScoreBar*) _score.first(); b!=0; b = (ScoreBar*) _score.next(b)) {
    b->setScale(_scale);
  }
  

}

long ScoreIterator::truncEnd(Note * note) {
  Note * nx = note;
  Position pNote = _part->start(note);
  long eNote = _part->end(note);

  for (; (nx != 0) && (_part->start(nx) == pNote); nx = (Note*) _part->next(nx)) {}
  if (nx==0) return eNote;
  else {
    long pNext = _part->start(nx).ticks();
    if ( eNote < pNext) return eNote;
    else return pNext;
  }
}


bool ScoreIterator::done() { return _ptr >= _max; }

bool ScoreIterator::reallyDone() {
  if (!Iterator::done()) return false;
  else {
    while ( !state->free_pos.sameBarOrGreater(_right) ) { // bar(free_pos) < bar(_right)
      add(0); // 0 means break
      nextbar();
    }
    // add((Note*)0, _right - state->free_pos.ticks(), state->free_pos);
    return true;
  }
}


Element * ScoreIterator::operator *() {
  if (_ptr < _max) return _score.get(_ptr);
  else return 0;
}

Iterator& ScoreIterator::operator++() {
  _ptr++;
  return *this;
}

Iterator ScoreIterator::operator++(int) {
  _ptr++;
  return *this;
}


#endif
