#ifndef _KDEAUDIOEDITOR_CPP_
#define _KDEAUDIOEDITOR_CPP_

#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <math.h>

#include <qsplitter.h>
#include <qpushbutton.h>
#include <qscrollview.h>
#include <qframe.h>
#include "kdeCursor.h"

#include "part.h"
#include "vector.h"
#include "str.h"
#include "event.h"
#include "song.h"
#include "note.h"
#include "audioEvent.h"
#include "position.h"
#include "addElement.h"
#include "iterator.h"
#include "audioTrack.h"
#include "addElement.h"
#include "removeElement.h"
#include "addToSelection.h"
#include "removeFromSelection.h"
#include "newSelection.h"
#include "moveEvent.h"
#include "copyEvent.h"
#include "changeNote.h"
#include "glueNote.h"
#include "splitNote.h"
#include "unselect.h"
#include "table.h"
#include "reference.h"
#include "scoreTrack.h"
#include "player.h"
#include "iterator.h"

#include "kdeAudioEditor.h"
#include "kdeAudioContent.h"
#include "kdeProgress.h"
#include "kdeEditorToolBar.h"
#include "kdeEditorMenuBar.h"
#include "brahmsResources.h"
#include "positionCursor.h"

#define ME ((KdeMainEditor*)mainEditor)

extern Song * sonG;
extern PrMainEditor * mainEditor;
extern Table * selectioN;



KdeAudioEditor::KdeAudioEditor() : KMainWindow(0L, "AudioEditor"), PrPartEditor(AUDIOEDITOR) {
  run();
}

KdeAudioEditor::KdeAudioEditor(Part * p) : KMainWindow(0L, "AudioEditor"), PrPartEditor(p) {
  run();
}

KdeAudioEditor::KdeAudioEditor(Track * t) : KMainWindow(0L, "AudioEditor"), PrPartEditor(t) {
  run();
}

KdeAudioEditor::~KdeAudioEditor() {

}

void KdeAudioEditor::run() {
  setCaption("Audio Editor"); // TODO: part name

  _grid_id = ID_GRID_4;
  //
  // Toolbars:
  // =========

  _toolbar = new KdeEditorToolBar(this,this);


  addToolBar( _toolbar );
  _toolbar->setBarPos(KToolBar::Top);


  //
  // Menubar:
  // ========
  //

  _filemenu = new QPopupMenu( this );
  _editmenu = new QPopupMenu( this );
  _gridmenu = new QPopupMenu( this );
  KdeEditorMenuBar::createMenuBar(menuBar(), _filemenu, _editmenu, _gridmenu);
  _gridmenu->setItemChecked(_grid_id,TRUE);
  connect(_filemenu,SIGNAL(activated(int)),SLOT(slotMenu(int)));
  connect(_editmenu,SIGNAL(activated(int)),SLOT(slotMenu(int)));
  connect(_gridmenu,SIGNAL(activated(int)),SLOT(slotGridMenu(int)));



  //
  // Contents:
  // =========


  _content = new KdeAudioContent( this, _toolbar);

  setGeometry(0,0,720, 560);
  _content->setGeometry(0,0,720, 560);
  setCentralWidget(_content);


  update();
  sonG->updateGui();
  setFocus();
}

void KdeAudioEditor::resizeEvent( QResizeEvent * ) {
}

void KdeAudioEditor::update() {
  repaint(FALSE);
}

void KdeAudioEditor::gui(GuiEvents ev, bool flag) {
  switch (ev) {
  case CHANGES:
    break;
  case UNDO:
    _toolbar->setItemEnabled( ID_EDIT_UNDO, flag );
    _editmenu->setItemEnabled( ID_EDIT_UNDO, flag );
    break;
  case REDO:
    _toolbar->setItemEnabled( ID_EDIT_REDO, flag );
    _editmenu->setItemEnabled( ID_EDIT_REDO, flag );
    break;
  case SELECTIONS:
    _toolbar->setItemEnabled( ID_EDIT_CUT, flag );
    _toolbar->setItemEnabled( ID_EDIT_COPY, flag );
    _toolbar->setItemEnabled( ID_EDIT_CLEAR, flag );
    _toolbar->setItemEnabled( ID_EDIT_TRANSPOSE, flag );
    //_toolbar->setItemEnabled( ID_EDIT_QUANTIZE_ALL, flag );
    //_toolbar->setItemEnabled( ID_EDIT_QUANTIZE_LENGTH, flag );
    //_toolbar->setItemEnabled( ID_EDIT_FIXED_LENGTH, flag );
    _editmenu->setItemEnabled( ID_EDIT_CUT, flag );
    _editmenu->setItemEnabled( ID_EDIT_COPY, flag );
    _editmenu->setItemEnabled( ID_EDIT_CLEAR, flag );
    _editmenu->setItemEnabled( ID_EDIT_TRANSPOSE, flag );
    _editmenu->setItemEnabled( ID_EDIT_QUANTIZE_ALL, flag );
    _editmenu->setItemEnabled( ID_EDIT_QUANTIZE_LENGTH, flag );
    _editmenu->setItemEnabled( ID_EDIT_FIXED_LENGTH, flag );
    break;
  case MEMORY:
    _toolbar->setItemEnabled( ID_EDIT_PASTE, flag );
    _editmenu->setItemEnabled( ID_EDIT_PASTE, flag );

    break;
  }
}

void KdeAudioEditor::print() {

}

void KdeAudioEditor::settings() {
}


void KdeAudioEditor::slotMenu(int i) {
  _toolbar->commandCallback(i);
}

void KdeAudioEditor::slotGridMenu(int i) {
  _gridmenu->setItemChecked(_grid_id,false);
  _grid_id = i;
  _gridmenu->setItemChecked(_grid_id,true);
}


void KdeAudioEditor::keyPressEvent ( QKeyEvent * key ) {
  _content->keyPressEvent(key);
}

void KdeAudioEditor::keyReleaseEvent ( QKeyEvent * key ) {
  _content->keyReleaseEvent(key);
}

// *****************************************************************************
//
// PAINT EVENT
// ===========
//

void KdeAudioEditor::paintEvent( QPaintEvent * ) {
  _content->repaint(FALSE);
}




void KdeAudioEditor::setCursorPosition(long ticks) {
  _content->moveCursor(ticks);
}

#endif
#include "kdeAudioEditor.moc"
