#ifndef _DRUMCONTENT_CPP_
#define _DRUMCONTENT_CPP_

    //
    // general remark:
    // all operations are Objects! Never ever(!) call an operation by method. Always use:
    // sonG->doo(new OPERATION(...));
    // this way operations are used within the undo/redo mechanism
    // operations are of course defined inside brahms/core
    //


#include "kdeDrumContent.h"

#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>

#include <qpixmap.h>
#include <qpainter.h>
#include <qpopupmenu.h>
#include <qcursor.h>
#include <klocale.h>

#include <kiconloader.h>

#include "kdeDrumContent.h"
#include "kdeDrumEditor.h"
#include "kdeProgress.h"
#include "kdeEditorToolBar.h"
#include "kdeEditorNoteBar.h"
#include "kdeEditorButtonBar.h"
#include "kdeCursor.h"
#include "kdeMainEditor.h"
#include "positionCursor.h"

#include "song.h"
#include "part.h"
#include "note.h"
#include "addElement.h"
#include "removeElement.h"
#include "addToSelection.h"
#include "removeFromSelection.h"
#include "newSelection.h"
#include "moveEvent.h"
#include "copyEvent.h"
#include "changeNote.h"
#include "glueNote.h"
#include "splitNote.h"
#include "unselect.h"
#include "table.h"
#include "reference.h"
#include "scoreTrack.h"
#include "player.h"
#include "iterator.h"

// Drums 35-81

const char * gmDrums[] = {"Acoustic Bass Drum", "Bass Drum 1", "Side Stick", "Acoustic Snare", "Hand Clap", "Electric Snare",
"Low Floor Tom", "Closed Hi-Hat", "High Floor Tom", "Pedal Hi-Hat", "Low Tom", "Open Hi-Hat", "Low-Mid Tom", "Hi-Mid Tom",
"Crash Cymbal 1", "High Tom", "Ride Cymbal 1", "Chinese Cymbal", "Ride Bell", "Tambourine", "Splash Cymbal", "Cowbell",
"Crash Cymbal 2", "Vibraslap", "Ride Cymbal 2", "Hi Bngo", "Low Bongo", "Mute Hi Conga", "Open Hi Conga", "Low Conga",
"Hi Timbale", "Low Timbale", "High Agogo", "Low Agogo", "Cabasa", "Maracas", "Short Whistle", "Long Whistle", "Short Guiro",
"Long Guiro", "Claves", "Hi Wood Block", "Low Wood Block", "Mute Cuica", "Open Cuica", "Mute Triangle", "Open Triangle"};

//
// for some info we need the mainEditor's GUI
//
#define ME ((KdeMainEditor*)mainEditor)
extern PrMainEditor * mainEditor;

//
// the song is a global object
// (later on it is planned to build a mechanism for multiple documents (songs))
// 
extern Song * sonG;

//
// the selection is global as well
// (which is good, it's not editor specific. OK, it could be a member of the mainEditor but, well...)
//
extern Table * selectioN;

//
// these tables map pitches to a y-coordinate
//

static unsigned char cpr[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,
 0x24,0x00,0x4e,0x00,0x5d,0x80,0x3e,0x40,0x1f,0xa0,0x0f,0xd0,0x07,0xe8,0x03,
 0xf4,0x01,0xfa,0x00,0x79,0x00,0x3f,0x00,0x1f,0x00,0x0f,0x00};



KdeDrumContent::KdeDrumContent(QFrame * parent, KdeDrumEditor * ed , KdeEditorToolBar * tb, KdeEditorNoteBar * nb, KdeEditorButtonBar * bb)
  : QFrame(parent,"content",QFrame::Sunken), _editor(ed), _toolbar(tb), _notebar(nb), _buttonbar(bb), _yscale(4), _yoffset(20),
    _mousey(0), _xoffset(120), _grab(0), _edit(0), _grabX(-1), shftFlag(false), ctrlFlag(false), suprFlag(false)
{
  _ybottom = _yoffset + _yscale*14*8;

  QBitmap cb( 15, 21, cpr, TRUE );
  QBitmap cm( 15, 21, cpr, TRUE );

  prcursor = new QCursor( cb, cm, 0, 19);
  moveWidget = new QFrame(this,"move");
  ((QFrame*)moveWidget)->setFrameStyle( QFrame::Panel | QFrame::Raised );
  moveWidget->setBackgroundMode(QWidget::PaletteBackground);
  moveWidget->hide();
  
  _position_cursor = new PositionCursor(this,_xoffset);


  QBitmap maske;
  KIconLoader * loader = KGlobal::iconLoader();
  img[0] = loader->loadIcon( "drum1", KIcon::Toolbar ); maske = img[0]; img[0].setMask( maske );
  img[1] = loader->loadIcon( "drum2", KIcon::Toolbar ); maske = img[1]; img[1].setMask( maske );
  img[2] = loader->loadIcon( "drum3", KIcon::Toolbar ); maske = img[2]; img[2].setMask( maske );
  img[3] = loader->loadIcon( "drum4", KIcon::Toolbar ); maske = img[3]; img[3].setMask( maske );
  img[4] = loader->loadIcon( "drum5", KIcon::Toolbar ); maske = img[4]; img[4].setMask( maske );
  img[5] = loader->loadIcon( "drum6", KIcon::Toolbar ); maske = img[5]; img[5].setMask( maske );
  img[6] = loader->loadIcon( "drum7", KIcon::Toolbar ); maske = img[6]; img[6].setMask( maske );
  img[7] = loader->loadIcon( "drum8", KIcon::Toolbar ); maske = img[7]; img[7].setMask( maske );

  //
  // rbmenu means: right-(mouse)button-menu
  //
  rbmenu = new QPopupMenu();
  rbmenu->connectItem( rbmenu->insertItem(i18n("glue to next note")), this, SLOT(glueNote()) );
  rbmenu->connectItem( rbmenu->insertItem(i18n("split note")), this, SLOT(splitNote()) );
  rbmenu->insertSeparator();
  rbmenu->connectItem( rbmenu->insertItem(i18n("delete note")), this, SLOT(deleteNote()) );
}

//
// glues a note to the next note
//
void KdeDrumContent::glueNote() {
  if (_edit!=0) {
    //
    // general remark:
    // all operations are Objects! Never ever(!) call an operation by method. Always use:
    // sonG->doo(new OPERATION(...));
    // this way operations are used within the undo/redo mechanism
    // operations are of course defined inside brahms/core
    //
    sonG->doo(new GlueNote(_edit, _editor->part()));
    _edit = 0;
    repaint(FALSE);
  }
}

//
// splits a note into two
//
void KdeDrumContent::splitNote() {
  if (_edit!=0) {
    sonG->doo(new SplitNote(_edit, _editor->part(), _editor->grid()));
    _edit = 0;
    repaint(FALSE);
  }
}

//
// deletes a note
//
void KdeDrumContent::deleteNote() {
  if (_edit!=0) {
    sonG->doo(new RemoveElement(_edit, _editor->part()));
    _edit = 0;
    repaint(FALSE);
  }
}

//
// determines the pitch by y-position of the mouse
//
int KdeDrumContent::Pitch(int y) {
  return 81-int((y-_yoffset-9)/9);
}


//
// converts pitch to the position on the screen
//
int KdeDrumContent::mouseY(int p) {
  return 0;
  // if (p == -1) return _yoffset + _yscale*invPcPitch[Pitch(_mousey)] + 2;
  // else         return _yoffset + _yscale*invPcPitch[Pitch(p)] + 2;
}




// ***************************************************
//
// PAINT EVENT
// ***********
//
//
// paintEvent is called from mouseMoveEvent with pe=0, to speed up the keyboard drawing.
// In this case, only the keyboard is to be drawn (so pe is abused as a marker)!
// do whatever you like if you want to change this... :-)
//

void KdeDrumContent::paintEvent(QPaintEvent * pe) {

  int wid = 80;
  if (pe!=0) { QFrame::paintEvent(pe); wid = width(); }
  
  setMouseTracking(TRUE);

  QPixmap pix( wid, height() );
  pix.fill( this, 10,10 );
  QPainter painter;
  painter.begin( &pix );
  
  //
  // _editor stores all important settings, it is the core-class PrPartEditor
  // don't forget to call the _editor->setSOMETHING(..) when settings are changed via gui!
  // (and don't invent members for non-gui specific settings! They are all in PrPartEditor!)
  //

  int xxx = width();
  painter.drawLine(16,_yoffset,16,_ybottom);
  painter.drawLine(_xoffset,2+_yoffset,_xoffset,_ybottom);
  painter.setFont(QFont("clean", 8));
  for (int i=0;i<=46;i++) if (13+i*9+_yoffset < _ybottom) painter.drawText(20,13+i*9+_yoffset,gmDrums[46-i]);
  painter.setPen(colorGroup().foreground());

  Position _leftPos = _editor->left();
  Position _rightPos = _editor->right();
  Part * _part = _editor->part();

  const char * name = _editor->PrPartEditor::name();
  ((KdeDrumEditor*) _editor)->setCaption(name);
  
  
  Note * note;
  int xmOffset = 0;
  unsigned long xx;
  int yy;
  int ind;
  int beat;
  int bar;
  int tick;
  Position pos = 0;
  Position add = Position(1,2,0); // one beat!
  char * txt = new char[12];
  bool draw = true;
  bool showNum;

  long diff = (_rightPos.ticks() - _leftPos.ticks()); // might be 0!
  double pixPerTick = 0.0;
  if (diff != 0)
    pixPerTick = (xxx-_xoffset-4.0) / diff;

  // double pixPerTick = (xxx-_xoffset-4.0)/(_rightPos.ticks()-_leftPos.ticks());


  while (draw) {
    xx = pos.ticks();
    xx = xx*pixPerTick + _xoffset;
    pos.gBBT(bar,beat,tick);
    
    if (beat==1) {
      sprintf(txt,"%d",bar+_leftPos.bar()-1);
      showNum = false;
      if (pixPerTick>0.015625) showNum = true;
      else if ((pixPerTick>0.0039) && ( (bar&3)==1 )) showNum = true;
      else if ((pixPerTick>0.0008) &&( (bar&15)==1 )) showNum = true;
      else if ((bar&127)==1) showNum = true;
      if (showNum) painter.drawText(xx+1,_yoffset-2,txt);
      if ((bar&7)==1) { painter.setPen(SolidLine); painter.drawLine(xx,_yoffset,xx,_ybottom); }
      else if (pixPerTick>0.0008) { painter.setPen(DashDotLine); painter.drawLine(xx,_yoffset,xx,_ybottom); }
    } else {
      if (pixPerTick>0.015625) { painter.setPen(DotLine); painter.drawLine(xx,_yoffset,xx,_ybottom); }
    }

    pos = pos + add;
    if (xx>xxx) draw=false;
  }
  painter.setPen(SolidLine);
  painter.drawLine(16,_yoffset,xxx,_yoffset); // draw horizontal borders
  painter.drawLine(16,_ybottom,xxx,_ybottom);


  //
  // loop over notes
  //

  for (Iterator i = Iterator(_editor); !i.done(); i++) {
    Event *event = (Event*) *i;
    Part *ptchn = i.change();
    _part = ptchn==0?_part:ptchn;
    if (event!=0) {
      pos = _part->start(event);
      // len = event->duration();
      if (event->isA()==NOTE) {
	note = (Note*) event;

	xx = (pos-_leftPos)*pixPerTick +  _xoffset;
	yy = _yoffset+7+9*(81-note->pitch());
	ind = int(note->vel()/18);
	
	if (selectioN->hasEntry(note)) img[ind].fill(Qt::red);
	painter.drawPixmap(xx-6,yy,img[ind]);
	if (selectioN->hasEntry(note)) img[ind].fill(Qt::black);
	
	painter.drawRect(xx+1,_ybottom+60,3,-note->vel()/3);
     
      }
    }
  }
  if (showY!=0) {
    painter.setPen(red);
    painter.drawLine(8,showY+_yoffset,12,showY+_yoffset);
  }

  
  
  //
  // selection frame
  //
  if (_grabX > -1) {
    painter.setPen(Qt::DashLine);
    if (_grab==0)
      painter.drawRect(_pressX,_pressY,_moveX-_pressX,_moveY-_pressY);
    painter.setPen(Qt::SolidLine);
  }

  painter.end();
  bitBlt( this, 0, 0, &pix );
  _notebar->update();

}



// ***************************************************
//
// MOUSE EVENT
// ***********
//
//

void KdeDrumContent::mousePressEvent( QMouseEvent * me ) {
  _pressX = me->x();
  _pressY = me->y();
  double pixPerTick = (width()-_xoffset-24.0)/(_editor->right().ticks()-_editor->left().ticks());
  long pos = _editor->snap((_pressX-_xoffset)/pixPerTick) + _editor->left().ticks();
  int pitch = Pitch(_pressY);
  if (me->button()==RightButton) {
    //
    // right button: context menu
    //
    _edit = _editor->getGrabNote(pos,pitch,_edit_length);
    if (_edit) rbmenu->popup( mapToGlobal(me->pos()), 0 );
  } else {
    //
    // left button
    //
    _grab = _editor->getGrabNote(pos,pitch,_edit_length);
    _grabY = mouseY();
    _grabX = int((_pressX-_xoffset)/pixPerTick + _editor->left().ticks()); // without snap!
    if (_grabX < 0) _grabX = 0;
    if (_grab!=0) {
      setCursor(ctrlFlag ? KdeCursor(KdeCursor::handCopy)
		: KdeCursor(KdeCursor::hand));
      _grabW = int(_grab->duration()*pixPerTick);
    moveWidget->setGeometry(_pressX-2, _grabY-2, _grabW, _yscale+4);
    }
  }
}


void KdeDrumContent::mouseMoveEvent( QMouseEvent * me ) {
  setFocus();
  _moveX = me->x();
  _moveY = me->y();
  double pixPerTick = (width()-_xoffset-24.0)/(_editor->right().ticks()-_editor->left().ticks());
  long pos = _editor->snap((_moveX-_xoffset)/pixPerTick) + _editor->left().ticks();
  long mpos = long((_moveX-_xoffset)/pixPerTick) + _editor->left().ticks();
  int pitch = Pitch(_moveY);
  bool el = false;
  Note * over = _editor->getGrabNote(mpos,pitch,el);

  if (_moveY!=_mousey) {
    _mousey = _moveY;
    paintEvent(0);
  }
  if (_grab!=0) { // NOTE GRABBED
    int y = mouseY()-2;
    if (shftFlag) y = _grabY-2;
    moveWidget->move(_moveX-2, y);
    if ((!moveWidget->isVisible()) && (!_edit_length)) moveWidget->show();
  } else {        // FREE
    _edit_length = el;
    if (_moveX > _xoffset) {
      if (_grabX > -1) {
	setCursor(QCursor(2));                          // CURSOR crosshair
	repaint(FALSE);
      } else {
	if (over) {
	  if (_edit_length) setCursor(QCursor(6));      // CURSOR horizontal resize
	  else              setCursor(QCursor(13));     // CURSOR pointing hand
	}
	else setCursor(*prcursor);                      // CURSOR pen
      }
    } else setCursor(QCursor(1));                       // CURSOR arrow up
  }
  if (_moveX > _xoffset-20 && _moveX < _xoffset) _moveX = _xoffset;
  if (_moveX > _xoffset) {
    int bar=0; int beat=0; int tick=0;
    sonG->bbt(bar,beat,tick,Position(pos));
    _buttonbar->setPos(bar,beat,tick);
  }
  _buttonbar->setPitch(pitch,false,false); // the 2.nd and 3.rd arguments are for score editing!
}


void KdeDrumContent::mouseReleaseEvent( QMouseEvent * me ) {
  setCursor(QCursor(*prcursor));                        // CURSOR pen
  double pixPerTick = (width()-_xoffset-24.0)/(_editor->right().ticks()-_editor->left().ticks());
  long pos = _editor->snap((me->x()-_xoffset)/pixPerTick) + _editor->left().ticks();
  int pitch = Pitch(me->y());
  int _grabY2 = mouseY();
  long _grabX2 = long((_moveX-_xoffset)/pixPerTick + _editor->left().ticks()); // without snap!
  Part * pt = _editor->part();
  ScoreTrack * tr = (ScoreTrack*) pt->track();

  if (_grab!=0) { // GRABBED NOTE
    if ((_grabY == _grabY2)&&(_grabX == _grabX2)) { // select
      if (shftFlag) {
	if (selectioN->hasEntry(_grab)) sonG->doo(new RemoveFromSelection(new Reference(_grab)));
	else                            sonG->doo(new AddToSelection(new Reference(_grab)));
      } else                            sonG->doo(new NewSelection(new Reference(_grab)));
    } else { // edit event
      if (_edit_length) { // edit length
	int len = pos - _editor->part()->start(_grab).ticks();
	// cout << len << endl;
	sonG->doo(new ChangeNote(_grab,_editor->part(),_grab->pitch(),len));
      } else {
	if (ctrlFlag) { // copy event
	  if (shftFlag) sonG->doo(new CopyEvent(Position(pos), _grab, _editor->part()));
	  else          sonG->doo(new CopyEvent(Position(pos), _grab, _editor->part(), pitch));
	} else {        // move event
	  if (shftFlag) sonG->doo(new MoveEvent(Position(pos), _grab, _editor->part()));
	  else          sonG->doo(new MoveEvent(Position(pos), _grab, _editor->part(), pitch));
	}
      }
    }
    moveWidget->hide();
  } else {      // FREE SPACE
    if (me->x() < _xoffset) {
      if (_editor->speaker()) sonG->player()->hit(tr->output(), tr->channel(), pitch, _editor->velocity());
    } else if (abs(_grabY-_grabY2)<4) { // new Note
      if (pitch>0) {
	long myLen = _editor->snap(_grabX2-_grabX);
	if (myLen<_editor->grid()*0.5) myLen = _editor->totalLength();
	if (sonG->editorAppearance()==ADJUSTPARAMETERS) { _editor->setLength(myLen); _buttonbar->setLength(_editor->lengthOrd(),_editor->dot(),_editor->tuplet()!=0); }
	if (_editor->speaker()) sonG->player()->hit(tr->output(), tr->channel(), pitch, _editor->velocity());
	sonG->doo(new AddElement(new Note(pitch,_editor->velocity(),myLen,_editor->snap(_grabX)-_editor->part()->start(),_editor->enharmonicShift()),_editor->part()));
      }
    } else { // selection
      if (shftFlag) sonG->doo(new AddToSelection(_editor->part()->makeRefs(Pitch(_grabY), Pitch(_grabY2), _grabX, _grabX2)));
      else          sonG->doo(new NewSelection(_editor->part()->makeRefs(Pitch(_grabY), Pitch(_grabY2), _grabX, _grabX2)));
    }
    _grab = 0;
    _grabX = -1;
    _editor->repaint(FALSE);
  }
  _grab = 0;
  _grabX = -1;
  // _editor->repaint(FALSE);
}





// ***************************************************
//
// KEY EVENT
// *********
//
//


void KdeDrumContent::keyPressEvent ( QKeyEvent * key ) {

  Reference * ref = (Reference*)selectioN->first();
  Event * ev = ref==0 ? 0 : (Event*) ref->getValue();

  switch( key->key() ) {
  case Key_Space:
    if (key->state()==AltButton) {
      double pixPerTick = (width()-_xoffset-24.0)/(_editor->right().ticks()-_editor->left().ticks());
      long pos = _editor->snap((_moveX-_xoffset)/pixPerTick) + _editor->left().ticks();
      _toolbar->setInsertPoint(pos);
    }
    break;
  case Key_Super_L:
    suprFlag = TRUE;
    break;
  case Key_Shift:
    shftFlag = TRUE;
    break;
  case Key_Control:
    ctrlFlag = TRUE;
    if (_grab!=0) setCursor(KdeCursor( KdeCursor::handCopy ));
    break;
  case Key_Left:
    _editor->moveselleft();
    break;
  case Key_Right:
    _editor->moveselright();
  break;
    
  case Key_PageUp:
    _editor->moveUp();
    if (selectioN->first()!=0) sonG->doo(new Unselect());
    update();
    break;

  case Key_PageDown:
    _editor->moveDown();
    if (selectioN->first()!=0) sonG->doo(new Unselect());
    update();
    break;

  case Key_Up:
    if (ev && (ev->isA()==NOTE)) {
      Note * note = (Note*) ev;
      sonG->doo(new ChangeNote(note, _editor->part(), note->pitch() + 1));
    }
    break;
  case Key_Down:
    if (ev && (ev->isA()==NOTE)) {
      Note * note = (Note*) ev;
      sonG->doo(new ChangeNote(note, _editor->part(), note->pitch() - 1));
    }
    break;
  case Key_Enter:
    if (_editor->part()!=0) {
      // sonG->play(0,_editor->part(),_editor->left().ticks(),_editor->right().ticks());
      sonG->play(0,_editor->part(),_editor->left().ticks(),sonG->right().ticks());
    }
    break;
  case Key_Insert:
  case Key_0:
    ME->slotStop();
    break;
  default:
    key->ignore();
  }
  // repaint( FALSE );
}


void KdeDrumContent::keyReleaseEvent ( QKeyEvent * key ) {
  switch( key->key() ) {
  case Key_Escape:
    // this is here, because keyPressEvent is not thrown for esc without shift, alt or meta...
    if (selectioN->first()!=0) sonG->doo(new Unselect());
    repaint(FALSE);
    break;
  case Key_Space:
    if (key->state()==AltButton) {
    }
    break;
  case Key_Shift:
    shftFlag = FALSE;
    break;
  case Key_Control:
    ctrlFlag = FALSE;
    if (_grab!=0) setCursor(KdeCursor( KdeCursor::hand ));
    break;
  case Key_Super_L:
    suprFlag = FALSE;
    break;
  default:
    key->ignore();
  }
}

void KdeDrumContent::moveCursor(int ticks) {
  double pixPerTick = (width()-_xoffset-24.0)/(_editor->right().ticks()-_editor->left().ticks());
  long pos = long((ticks-_editor->left().ticks())*pixPerTick);
  if (pos>width()-24) {
    _editor->moveleft(_editor->numberOfBars());
  }
  _position_cursor->move(pos-3);
  
}



#endif
#include "kdeDrumContent.moc"
