#ifndef _KDENOTEBAR_CPP_
#define _KDENOTEBAR_CPP_

#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>

#include "kdeEditorNoteBar.h"

#include "prPartEditor.h"
#include "event.h"
#include "moveEvent.h"
#include "changeNote.h"
#include "note.h"
#include "song.h"
#include "part.h"
#include "masterEvent.h"
#include "midiEvent.h"
#include "symbol.h"
#include "reference.h"

#include <qstring.h>
#include <qcursor.h>
#include <qlineedit.h>

extern Song * sonG;
extern Table * selectioN;

KdeEditorNoteBar::KdeEditorNoteBar( QWidget * parent, PrPartEditor * ed )
  : KToolBar( parent ), _editor(ed)
{

  // Position
  QLabel * lPos = new QLabel("start ",this);
  // lPos->setGeometry(14,2,30,18);
  insertWidget(-1,30,lPos);

  start = new QLineEdit( this );
  start->setGeometry(44,2,82,18);
  start->setFrame(false);
  connect(start,SIGNAL(returnPressed()),SLOT(startCF()));
  start->show();

  // Length
  QLabel * lLen = new QLabel("length ",this);
  lLen->setGeometry(128,2,40,18);

  length = new QLineEdit( this );
  length->setGeometry(168,2,62,18);
  length->setFrame(false);
  connect(length,SIGNAL(returnPressed()),SLOT(lengthCF()));
  length->show();

  // Pitch
  QLabel * lFreq = new QLabel("pitch ",this);
  lFreq->setGeometry(236,2,40,18);

  freq = new QLineEdit( this );
  freq->setGeometry(276,2,62,18);
  freq->setFrame(false);
  connect(freq,SIGNAL(returnPressed()),SLOT(freqCF()));
  freq->show();

  // Velocity
  QLabel * lVel = new QLabel("vel ",this);
  lVel->setGeometry(344,2,40,18);

  vel = new QLineEdit( this );
  vel->setGeometry(384,2,62,18);
  vel->setFrame(false);
  connect(vel,SIGNAL(returnPressed()),SLOT(velCF()));
  vel->show();

  // Channel
  QLabel * lChan = new QLabel("chn ",this);
  lChan->setGeometry(450,2,40,18);
  
  chan = new QLineEdit( this );
  chan->setGeometry(490,2,62,18);
  chan->setFrame(false);
  connect(chan,SIGNAL(returnPressed()),SLOT(chanCF()));
  chan->show();

  // Enharmonic Shift
  QLabel * lEnh = new QLabel("enh.shft ",this);
  lEnh->setGeometry(560,2,50,18);
  lEnh->show();

  enhLabel = new QComboBox(this);
  enhLabel->setGeometry(610,2,40,18);
  enhLabel->insertItem("bb",0);  // TODO: replace by images!
  enhLabel->insertItem("b",1);
  enhLabel->insertItem("n",2);
  enhLabel->insertItem("#",3);
  enhLabel->insertItem("x",4);
  connect(enhLabel,SIGNAL(activated(int)),SLOT(enhCF()));
  enhLabel->show();

  //scanvas->showNoteInfoOff();
  setCursor(QCursor(0));
  clear();

}

void KdeEditorNoteBar::startCF() { startEnter(); start->clearFocus(); ((QWidget*)parent())->setFocus(); }
void KdeEditorNoteBar::lengthCF() { lengthEnter(); length->clearFocus(); ((QWidget*)parent())->setFocus(); }
void KdeEditorNoteBar::freqCF() { freqEnter(); freq->clearFocus(); ((QWidget*)parent())->setFocus(); }
void KdeEditorNoteBar::velCF() { velEnter(); vel->clearFocus(); ((QWidget*)parent())->setFocus(); }
void KdeEditorNoteBar::chanCF() { chanEnter(); chan->clearFocus(); ((QWidget*)parent())->setFocus(); }
void KdeEditorNoteBar::enhCF() { enhEnter(); enhLabel->clearFocus(); ((QWidget*)parent())->setFocus(); }

void KdeEditorNoteBar::startEnter() {
  Reference * ref = (Reference*)selectioN->first();
  Event * ev = ref==0 ? 0 : (Event*) ref->getValue();
  if (ev!=0) {
    const char * line = start->text();
    int x1 = atoi(line);
    for (;line[0]!='.';line++) {} line++; for (;line[0]==' ';line++) {}
    int x2 = atoi(line);
    for (;line[0]!='.';line++) {} line++; for (;line[0]==' ';line++) {}
    int x3 = atoi(line);
    int ticks = int(1536.0*_editor->part()->meter0()/_editor->part()->meter1());
    int pos = ticks*(x1-1) + ticks*(x2-1)/_editor->part()->meter0() + x3;
    if (pos>=0) {
      sonG->doo(new MoveEvent(Position(pos), ev, _editor->part()));
    }
    // start->setFrame(FALSE);
    
    ((QWidget*)parent())->repaint( FALSE );
  }
}

void KdeEditorNoteBar::lengthEnter() {
  Reference * ref = (Reference*)selectioN->first();
  Event * ev = ref==0 ? 0 : (Event*) ref->getValue();
  if ((ev!=0)&&(ev->isA()==NOTE)) {
    int l = atoi(length->text());
    Note * note = (Note*) ev;
    if (l>=0) sonG->doo(new ChangeNote(note, _editor->part(), note->pitch(), l));
    // length->setFrame(FALSE);
    ((QWidget*)parent())->repaint( FALSE );
  }
}

void KdeEditorNoteBar::freqEnter() {
  Reference * ref = (Reference*)selectioN->first();
  Event * ev = ref==0 ? 0 : (Event*) ref->getValue();
  if ((ev!=0)&&(ev->isA()==NOTE)) {
    const char * line = freq->text();
    int o = atoi(line+1);
    if (o==0) o = atoi(line+2);
    int f = 24;
    switch (line[0]) {
    case 'c': f = 24; break;
    case 'd': f = 26; break;
    case 'e': f = 28; break;
    case 'f': f = 29; break;
    case 'g': f = 31; break;
    case 'a': f = 33; break;
    case 'h': f = 35; break;
    case 'b': f = 35; break;
    case 'C': f = 24; break;
    case 'D': f = 26; break;
    case 'E': f = 28; break;
    case 'F': f = 29; break;
    case 'G': f = 31; break;
    case 'A': f = 33; break;
    case 'H': f = 35; break;
    case 'B': f = 35; break;
    }
    switch (line[1]) {
    case '#': f+=1; break;
    case 'b': f-=1; break;
    }
    f+=12*o;
    Note * note = (Note*) ev;
    sonG->doo(new ChangeNote(note, _editor->part(), f));
    // freq->setFrame(FALSE);
    ((QWidget*)parent())->repaint( FALSE );
  }
}

void KdeEditorNoteBar::velEnter() {
  Reference * ref = (Reference*)selectioN->first();
  Event * ev = ref==0 ? 0 : (Event*) ref->getValue();
  if ((ev!=0)&&(ev->isA()==NOTE)) {
    int v = atoi(vel->text());
    Note * note = (Note*) ev;
    sonG->doo(new ChangeNote(note, _editor->part(), note->pitch(), note->duration(), v));
    // vel->setFrame(FALSE);
    ((QWidget*)parent())->repaint( FALSE );
  }
}

void KdeEditorNoteBar::chanEnter() {
  Reference * ref = (Reference*)selectioN->first();
  Event * ev = ref==0 ? 0 : (Event*) ref->getValue();
  if ((ev!=0)&&(ev->isA()==NOTE)) {
    int c = 0;
    if (strcmp(chan->text(),"x")==0) c = -1;
    else c = atoi(chan->text());
    if ((c < -2)||(c > 15)) c = -1;
    Note * note = (Note*) ev;
    sonG->doo(new ChangeNote(note, _editor->part(), note->pitch(), note->duration(), note->vel(), note->enh(), c));
    ((QWidget*)parent())->repaint( FALSE );
  }
}

void KdeEditorNoteBar::enhEnter() {
  Reference * ref = (Reference*)selectioN->first();
  Event * ev = ref==0 ? 0 : (Event*) ref->getValue();
  if ((ev!=0)&&(ev->isA()==NOTE)) {
    // cout << enhLabel->currentItem() << endl;
    Note * note = (Note*) ev;
    int en = enhLabel->currentItem()-2;
    sonG->doo(new ChangeNote(note, _editor->part(), note->pitch(), note->duration(), note->vel(), en));
    ((QWidget*)parent())->repaint( FALSE );
  }
}

void KdeEditorNoteBar::setStart(int bar, int beat, int tick) {
  sprintf(position,"%3d.%2d.%3d",bar,beat,tick);
  start->setEnabled(true);
  start->setFrame(true);
  start->setText(position);
}

void KdeEditorNoteBar::setLength(int len) {
  sprintf(lengths,"%d",len);
  length->setEnabled(true);
  length->setFrame(true);
  length->setText(lengths);
}

void KdeEditorNoteBar::setPitch(int p) {
  int n = p%12;
  char ff = 0;
  char sg = 0;
  switch (n) {
  case 0: ff = 'c'; sg =' '; break;
  case 1: ff = 'c'; sg ='#'; break;
  case 2: ff = 'd'; sg =' '; break;
  case 3: ff = 'd'; sg ='#'; break;
  case 4: ff = 'e'; sg =' '; break;
  case 5: ff = 'f'; sg =' '; break;
  case 6: ff = 'f'; sg ='#'; break;
  case 7: ff = 'g'; sg =' '; break;
  case 8: ff = 'g'; sg ='#'; break;
  case 9: ff = 'a'; sg =' '; break;
  case 10: ff = 'a'; sg ='#'; break;
  case 11: ff = 'h'; sg =' '; break;
  }
  if (sg==' ') sprintf(pitch,"%c%d",ff,(int)p/12-2);
  else sprintf(pitch,"%c%c%d",ff,sg,(int)p/12-2);
  freq->setEnabled(true);
  freq->setFrame(true);
  freq->setText(pitch);
}

void KdeEditorNoteBar::setVelocity(int v) {
  sprintf(velocity,"%d",v);
  vel->setEnabled(true);
  vel->setFrame(true);
  vel->setText(velocity);
}

void KdeEditorNoteBar::setEnh(int e) {
  enhLabel->setEnabled(TRUE);
  enhLabel->setBackgroundMode(PaletteBackground);
  // enhLabel->select(e); // +2, weil select der SLOT fuer das Popup ist, das von 0 bis 5 geht ;-)
  enhLabel->setCurrentItem(e+2);
}

void KdeEditorNoteBar::setChan(int c) {
  if (c!=-1) sprintf(channel,"%d",c);
  else sprintf(channel,"x");
  chan->setEnabled(true);
  chan->setFrame(true);
  chan->setText(channel);
}

void KdeEditorNoteBar::clear() {
  start->setText(" --.-.--- ");
  start->setEnabled(FALSE);
  start->setFrame(false);
  length->setText(" --- ");
  length->setEnabled(FALSE);
  length->setFrame(false);
  freq->setText(" -- ");
  freq->setEnabled(FALSE);
  freq->setFrame(false);
  vel->setText(" -- ");
  vel->setEnabled(FALSE);
  vel->setFrame(false);
  // enhLabel->setText(" - ");
  // enhLabel->setCurrentItem(5);
  enhLabel->setEnabled(FALSE);
  chan->setText(" - ");
  chan->setEnabled(FALSE);
  chan->setFrame(false);
}

void KdeEditorNoteBar::update() {
  Event * ev = _editor->currentEvent();
  if (ev != 0) {
    // pos
    int bar=0; int beat=0; int ticks=0;
    sonG->bbt(bar,beat,ticks,_editor->part()->start(ev));
    setStart(bar,beat,ticks);
    // len
    setLength(int(ev->duration()));
    switch (ev->isA()) {
    case MASTEREVENT:
      break;
    case MIDIEVENT:
      setPitch(((MidiEvent*)ev)->code());
      setVelocity(((MidiEvent*)ev)->value1());
      // TODO: setVelocity(((MidiEvent*)ev)->value2());
      setChan(((MidiEvent*)ev)->channel());
      break;
    case NOTE:
      setPitch(((Note*)ev)->pitch());
      setVelocity(((Note*)ev)->vel());
      setEnh(((Note*)ev)->enh());
      setChan(((Note*)ev)->chan());
      break;
    case SYMBOL:
      break;
    default:
      break;
    }
  } else {
    clear();
  }
}





#endif
#include "kdeEditorNoteBar.moc"
