#ifndef _KDEPREFS_C_
#define _KDEPREFS_C_

#include <iostream.h>

#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qtabdialog.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qpushbutton.h>

#include "song.h"

#include "kdePrefs.h"
#include "kdeMainEditor.h"

extern Song * sonG;
extern PrMainEditor * mainEditor;

#define ME ((KdeMainEditor*)mainEditor)


KdePrefs::KdePrefs( QWidget * parent , const char * name )
    : QLabel( parent, name )
{
  dialog = new QTabDialog();

  // ---------------------------------
  //
  // Song Info
  //
  
  pref4 = new QWidget(dialog, "page 1");

  QLabel * l41 = new QLabel("Song Title: ",pref4);
  QLabel * l42 = new QLabel("Comments: ",pref4);
  QLabel * l43 = new QLabel("Author: ",pref4);
  QLabel * l44 = new QLabel("Filename: ",pref4);
  QLabel * l45 = new QLabel("Projectpath: ",pref4);
  e41 = new QLineEdit(pref4); e41->setText(sonG->title());
  e42 = new QLineEdit(pref4); e42->setText(sonG->comment());
  e43 = new QLineEdit(pref4); e43->setText(sonG->author());
  QLineEdit * e44 = new QLineEdit(pref4); e44->setText(ME->filename()); e44->setEnabled(false);
  const char * pd = ME->projectDir();
  QLineEdit * e45 = new QLineEdit(pref4); e45->setText(pd==0?"-":pd); e45->setEnabled(false);
  QPushButton * ok = new QPushButton( "accept", pref4 );
  l41->setGeometry(10,20,90,30);
  l42->setGeometry(10,50,90,30);
  l43->setGeometry(10,80,90,30);
  l44->setGeometry(10,120,90,30);
  l45->setGeometry(10,150,90,30);
  e41->setGeometry(100,20,200,30);
  e42->setGeometry(100,50,200,30);
  e43->setGeometry(100,80,200,30);
  e44->setGeometry(100,120,200,30);
  e45->setGeometry(100,150,200,30);
  ok->setGeometry(100,200,60,30);
  connect(e41,SIGNAL(returnPressed()),SLOT(updateE41()));
  connect(e42,SIGNAL(returnPressed()),SLOT(updateE42()));
  connect(e43,SIGNAL(returnPressed()),SLOT(updateE43()));
  connect(ok, SIGNAL(pressed()), SLOT(ok()));

  dialog->addTab(pref4, "general");


  // -------------------------------------
  //
  // MIDI SETUP
  //

  pref1 = new QWidget(dialog, "page 2");
  group1 = new QGroupBox("Click", pref1, "midisetup");
  group1->setGeometry(20,20,200,140);

  //  l0 = new QLabel("Click",group1);
  l11 = new QLabel("Beep:",group1);
  c11 = new QCheckBox(group1);
  //l12 = new QLabel("Use MIDI:",group1);
  //c12 = new QCheckBox(group1);
  l13 = new QLabel("Instrument No.",group1);
  s11 = new QSpinBox(0,127,1,group1);
  l14 = new QLabel("Volume",group1);
  s12 = new QSpinBox(0,127,1,group1);
  l15 = new QLabel("Precount",group1);
  s13 = new QSpinBox(0,8,1,group1);

  /* TODO!
  c11->setChecked(qtmain->gMain()->gBeepFlag()); connect(c11, SIGNAL(toggled(bool)), SLOT(updateC1(bool)));
  // c12->setChecked(qtmain->gMain()->gBeepMidi()); connect(c12, SIGNAL(toggled(bool)), SLOT(updateC2(bool)));
  s11->setValue(qtmain->gMain()->gClickInst()); connect(s11, SIGNAL(valueChanged(int)), SLOT(updateS1(int)));
  s12->setValue(qtmain->gMain()->gClickVol()); connect(s12, SIGNAL(valueChanged(int)), SLOT(updateS2(int)));
  s13->setValue(qtmain->gMain()->gPreBeats()); connect(s13, SIGNAL(valueChanged(int)), SLOT(updateS3(int)));
  */

  l11->setGeometry(10,20,100,20);
  //  l12->setGeometry(10,40,100,20);
  l13->setGeometry(10,60,100,20);
  l14->setGeometry(10,80,100,20);
  l15->setGeometry(10,100,100,20);

  c11->setGeometry(110,20,60,20);
  // c12->setGeometry(110,40,60,20);
  s11->setGeometry(110,60,60,20);
  s12->setGeometry(110,80,60,20);
  s13->setGeometry(110,100,60,20);
  
  dialog->addTab(pref1, "MIDI Setup");

  // ---------------------------------
  //
  // Playback
  //
  
  pref2 = new QWidget(dialog, "page 3");
  l21 = new QLabel("Wait For Acoustic\nSignal Before Playing", pref2);
  c21 = new QCheckBox(pref2);

  /* TODO!
  c21->setChecked(qtmain->gMain()->gPlayWait()); connect(c21, SIGNAL(toggled(bool)), SLOT(updateC21(bool)));
  */
  l21->setGeometry(10,40,140,40);
  c21->setGeometry(150,40,60,40);

  dialog->addTab(pref2, "playback");

  // ---------------------------------
  //
  // Desktop
  //
  pref3 = new QWidget(dialog, "page 4");
  
  g31 = new QButtonGroup("part appearance", pref3, "desktop");
  g31->setGeometry(20,20,200,140);
  r31 = new QRadioButton("plain",g31);
  r32 = new QRadioButton("show trackname",g31);
  r33 = new QRadioButton("show instrument",g31);
  r34 = new QRadioButton("show part events",g31);
  
  r31->setGeometry(10,20,140,20);
  r32->setGeometry(10,40,140,20);
  r33->setGeometry(10,60,140,20);
  r34->setGeometry(10,80,140,20);
  r31->setChecked(sonG->partAppearance()==CLEAN);
  r32->setChecked(sonG->partAppearance()==TRACKNAME);
  r33->setChecked(sonG->partAppearance()==INSTRUMENT);
  r34->setChecked(sonG->partAppearance()==EVENTS);

  connect(g31,SIGNAL(clicked(int)),SLOT(updateG31(int)));
  

  g32 = new QButtonGroup(pref3);
  g32->setGeometry(20,170,200,40);

  l31 = new QLabel("Undo memory:",g32);
  s31 = new QSpinBox(0,127,1,g32);
  s31->setValue(ME->undoMemory()); connect(s31, SIGNAL(valueChanged(int)), SLOT(updateS4(int)));
  l31->setGeometry(10,10,100,20);
  s31->setGeometry(110,10,60,20);
  

  dialog->addTab(pref3, "desktop");

  // ---------------------------------
  //
  // Editors
  //
  pref5 = new QWidget(dialog, "page 5");
  
  g51 = new QButtonGroup("note property behaviour", pref5, "editors");
  g51->setGeometry(20,20,200,140);
  r51 = new QRadioButton("adjust parameters from selected note",g51);
  r52 = new QRadioButton("don't adjust parameters",g51);
  r51->setGeometry(10,20,140,20);
  r52->setGeometry(10,40,140,20);
  r51->setChecked(sonG->editorAppearance()==ADJUSTPARAMETERS);
  r52->setChecked(sonG->editorAppearance()==NOADJUST);


  g52 = new QButtonGroup(pref5);
  g52->setGeometry(20,170,200,40);
  l51 = new QLabel("editor background:",g52);
  s51 = new QComboBox(g52);
  s51->insertItem("none");
  s51->insertItem("paper");
  s51->insertItem("user defined");
  l51->setGeometry(10,10,100,20);
  s51->setGeometry(110,10,60,20);
  s51->setCurrentItem( ME->editorBackground() );
  
  connect(g51,SIGNAL(clicked(int)),SLOT(updateG51(int)));
  connect(s51,SIGNAL(highlighted(int)),SLOT(updateS52(int)));
  
  /*
  g52 = new QButtonGroup(pref5);
  g52->setGeometry(20,170,200,40);

  l51 = new QLabel("Undo memory:",g52);
  s51 = new QSpinBox(0,127,1,g52);
  s51->setValue(ME->undoMemory()); connect(s51, SIGNAL(valueChanged(int)), SLOT(updateS5(int)));
  l51->setGeometry(10,10,100,20);
  s51->setGeometry(110,10,60,20);
  */

  dialog->addTab(pref5, "editors");




  dialog->setFixedSize(420,340);






  dialog->show();
}

KdePrefs::~KdePrefs() {
  delete l11; delete l13; delete l14; delete l15;
  delete c11; delete s11; delete s12; delete s13;
  delete group1; delete pref1;
  delete l21; delete c21;
  delete pref2;
  delete dialog;
}

void KdePrefs::updateG31(int n) {
  // cout << n << endl;
  sonG->setPartAppearance((PartApp)n);
  mainEditor->update();
}

void KdePrefs::updateG51(int n) {
  sonG->setEditorAppearance((EditorApp)n);
  mainEditor->update();
}

void KdePrefs::updateC1(bool ) {
  // TODO: qtmain->gMain()->sBeepFlag(on);
}

void KdePrefs::updateC2(bool ) {
  // TODO: qtmain->gMain()->sBeepMidi(on);
}

void KdePrefs::updateS1(int ) {
  // TODO: qtmain->gMain()->sClickInst(n);
}

void KdePrefs::updateS2(int ) {
  // TODO: qtmain->gMain()->sClickVol(n);
}

void KdePrefs::updateS3(int ) {
  // TODO: qtmain->gMain()->sPreBeats(n);
}

void KdePrefs::updateS4(int n) {
  ME->setUndoMemory(n);
}

void KdePrefs::updateC21(bool ) {
  // TODO: qtmain->gMain()->sPlayWait(on);
}


void KdePrefs::updateE41() {
  sonG->setTitle(strdup(e41->text()));
}

void KdePrefs::updateE42() {
  sonG->setComment(strdup(e42->text()));
}

void KdePrefs::updateE43() {
  sonG->setAuthor(strdup(e43->text()));
}

void KdePrefs::updateS52(int i) {
  cout << i << endl;
  ME->setEditorBackground(i);
}

void KdePrefs::ok() {
  updateE41();
  updateE42();
  updateE43();
  // TODO: qtmain->sFileName("");
}





#endif
#include "kdePrefs.moc"
