#ifndef _KDESCOREEDITOR_CPP_
#define _KDESCOREEDITOR_CPP_

#include <stdio.h>
#include <iostream.h>
#include <math.h>

#include <kiconloader.h>
#include <klocale.h>
#include <kmenubar.h>

#include <qbitmap.h>
#include <qpopupmenu.h>
#include <qsplitter.h>
#include <qscrollview.h>

#include "part.h"
#include "track.h"
#include "song.h"
#include "lyrics.h"

#include "kdeScoreEditor.h"
#include "kdeEditorToolBar.h"
#include "kdeEditorNoteBar.h"
#include "kdeEditorButtonBar.h"
#include "kdeEditorScrollBar.h"
#include "kdeEditInfo.h"
#include "kdeEditorMenuBar.h"
#include "kdeScoreContent.h"
#include "brahmsResources.h"

#include "qtScoreAddons.h"

#define YTOP 12

extern Song * sonG;


enum { ID_TOOL_IN, ID_TOOL_ANS, ID_TOOL_AOS, ID_TOOL_LYR };
enum { ID_OPTIONS_NOTEBAR, ID_OPTIONS_AUTHOR, ID_OPTIONS_AUX, ID_OPTIONS_NEXT, ID_OPTIONS_STN, ID_OPTIONS_SIN, ID_OPTIONS_LYRICS, ID_OPTIONS_VOLUMES };


KdeScoreEditor::KdeScoreEditor()
  : KMainWindow(0L, "ScoreEditor"), PrScoreEditor()
{
  run();
}

KdeScoreEditor::KdeScoreEditor(Part * p)
  : KMainWindow(0L, "ScoreEditor"), PrScoreEditor(p)
{
  run();
}

KdeScoreEditor::KdeScoreEditor(Track * t)
  : KMainWindow(0L, "ScoreEditor"), PrScoreEditor(t)
{
  run();
}

void KdeScoreEditor::run() {
  //
  // init
  //
  setCaption("Score Editor"); // TODO: part name

  _tool = ID_TOOL_IN;
  _ybottom = YTOP + 100*parts();
  _grid_id = ID_GRID_4;
  _dyn_id = 86;
  _toolbarstate = true;
  _notebarstate = false;
  _buttonbarstate = true;
  _sliderstate = true;
  showIN = true;
  showTN = false;

  //
  // Toolbars:
  // =========

  _toolbar = new KdeEditorToolBar(this,this);
  _notebar = new KdeEditorNoteBar(this,this);
  _buttonbar = new KdeEditorButtonBar(this,this);
  _scrollbar = new KdeEditorScrollBar(this,this);
  

  addToolBar( _toolbar ); _toolbar->setBarPos(KToolBar::Top); if (_toolbarstate) _toolbar->show(); else _toolbar->hide();
  addToolBar( _notebar ); _notebar->setBarPos(KToolBar::Top); if (_notebarstate) _notebar->show(); else _notebar->hide();
  addToolBar( _buttonbar ); _buttonbar->setBarPos(KToolBar::Top); if (_buttonbarstate) _buttonbar->show(); else _buttonbar->hide();
  addToolBar( _scrollbar ); _scrollbar->setBarPos(KToolBar::Bottom); if (_sliderstate) _scrollbar->show(); else _scrollbar->hide();

  //
  // Menubar:
  // ========
  //

  _filemenu = new QPopupMenu( this );
  _editmenu = new QPopupMenu( this );
  _gridmenu = new QPopupMenu( this );
  _dynamicsmenu = new QPopupMenu( this );
  _viewmenu = new QPopupMenu( this );
  KdeEditorMenuBar::createMenuBar(menuBar(), _filemenu, _editmenu, _gridmenu, _dynamicsmenu, _viewmenu);
  _gridmenu->setItemChecked(_grid_id,TRUE);
  _dynamicsmenu->setItemChecked(_dyn_id,TRUE);
  _viewmenu->setItemChecked(ID_VIEW_TOOLBAR, _toolbarstate);
  _viewmenu->setItemChecked(ID_VIEW_NOTEBAR , _notebarstate);
  _viewmenu->setItemChecked(ID_VIEW_BUTTONBAR, _buttonbarstate);
  _viewmenu->setItemChecked(ID_VIEW_SLIDER, _sliderstate);
  connect(_filemenu,SIGNAL(activated(int)),SLOT(slotMenu(int)));
  connect(_editmenu,SIGNAL(activated(int)),SLOT(slotMenu(int)));
  connect(_gridmenu,SIGNAL(activated(int)),SLOT(slotGridMenu(int)));
  connect(_dynamicsmenu,SIGNAL(activated(int)),SLOT(slotDynMenu(int)));
  connect(_viewmenu,SIGNAL(activated(int)),SLOT(slotViewMenu(int)));

  _toolmenu = new QPopupMenu( this );
  _toolmenu->insertItem( i18n("Insert Notes"), ID_TOOL_IN );
  _toolmenu->insertItem( i18n("Add Note Symbols"), ID_TOOL_ANS );
  _toolmenu->insertItem( i18n("Add System Symbols"), ID_TOOL_AOS );
  _toolmenu->insertItem( i18n("Add Lyrics"), ID_TOOL_LYR );
  _toolmenu->setAccel(ALT+Key_N,ID_TOOL_IN);
  _toolmenu->setAccel(ALT+Key_A,ID_TOOL_ANS);
  _toolmenu->setAccel(ALT+Key_S,ID_TOOL_AOS);
  _toolmenu->setAccel(ALT+Key_L,ID_TOOL_LYR);

  _toolmenu->setCheckable(true);
  _toolmenu->setItemChecked(_tool, true);
  connect(_toolmenu,SIGNAL(activated(int)),SLOT(toolMenu(int)));

  _optionsmenu = new QPopupMenu( this );
  _optionsmenu->insertItem( i18n("Show Tracknames"), ID_OPTIONS_STN );
  _optionsmenu->insertItem( i18n("Show Instrumentnames"), ID_OPTIONS_SIN );
  _optionsmenu->insertSeparator();
  /*  _optionsmenu->insertItem( i18n("Show Lyrics"), ID_OPTIONS_LYRICS );
  _optionsmenu->insertItem( i18n("Show Volumes"), ID_OPTIONS_VOLUMES );
  _optionsmenu->setCheckable(true); */
  _optionsmenu->setItemChecked(ID_OPTIONS_SIN,showIN);
  _optionsmenu->setItemChecked(ID_OPTIONS_STN,showTN);
  connect(_optionsmenu,SIGNAL(activated(int)),SLOT(optionsMenu(int)));

  menuBar()->insertItem(i18n("Tools"),_toolmenu);
  menuBar()->insertItem(i18n("Options"),_optionsmenu);
  

  //
  // Contents:
  // =========
  setMinimumWidth(720);
  _splitter = new QSplitter(Qt::Vertical,this);
  // _area = new QWidget( this );

  _scroller = new QScrollView( _splitter, "Scroller", QFrame::Raised );
  _scroller->setHScrollBarMode(QScrollView::AlwaysOff);
  _scroller->setVScrollBarMode(QScrollView::AlwaysOn);
  

  _content = new KdeScoreContent( _scroller, this, _toolbar, _notebar, _buttonbar );
  _content->setBackgroundMode( QWidget::PaletteLight );
  _scroller->addChild(_content);

  _info = new KdeEditInfo( _splitter, this );
  _info->setBackgroundMode( QWidget::PaletteMidlight );

  setCentralWidget( _splitter );
  _scroller->setGeometry(0,0,width(),_ybottom+4);
  // _scroller->setFixedHeight(_ybottom+4);
  _scroller->setMinimumHeight(100+YTOP+4);
  _scroller->setMaximumHeight(_ybottom+4);
  _content->setGeometry(0,0,width()-20,_ybottom);
  _content->setFixedHeight(_ybottom);
  _info->setGeometry(0,_ybottom+5,width(),120);
  _info->setFixedHeight(120);
  // _scroller->setMinimumHeight(height()-140);
  // _scroller->setMinimumHeight(100+YTOP);
  _splitter->setFixedHeight(_ybottom+126);
  // setMaximumHeight(_ybottom+126);
  // setFixedHeight(_ybottom+126);
  
  update();
  setFocus();
  sonG->updateGui();
  _toolbar->update();

}

void KdeScoreEditor::resizeEvent( QResizeEvent * ) {
  
  // setMaximumHeight(_ybottom+126);
  // _splitter->setGeometry(0,0,width(),_ybottom+126);
  _scroller->setGeometry(0,0,width(),_ybottom+4);
  _content->setGeometry(0,0,width()-20,_ybottom);
  _info->setGeometry(0,_ybottom,width(),120);
  // _splitter->setMaximumHeight(_ybottom+120);
  
}


bool KdeScoreEditor::showInstrumentName() { return showIN; }

bool KdeScoreEditor::showTrackName() { return showTN; }

void KdeScoreEditor::update() {
  _content->repaint(FALSE);
  _info->repaint(FALSE);
  _buttonbar->setLength(lengthOrd(),dot(),tuplet()>0);
}

void KdeScoreEditor::gui(GuiEvents ev, bool flag) {
  switch (ev) {
  case CHANGES:
    break;
  case UNDO:
    _toolbar->setItemEnabled( ID_EDIT_UNDO, flag );
    _editmenu->setItemEnabled( ID_EDIT_UNDO, flag );
    break;
  case REDO:
    _toolbar->setItemEnabled( ID_EDIT_REDO, flag );
    _editmenu->setItemEnabled( ID_EDIT_REDO, flag );
    break;
  case SELECTIONS:
    _toolbar->setItemEnabled( ID_EDIT_CUT, flag );
    _toolbar->setItemEnabled( ID_EDIT_COPY, flag );
    _toolbar->setItemEnabled( ID_EDIT_CLEAR, flag );
    _toolbar->setItemEnabled( ID_EDIT_TRANSPOSE, flag );
    _editmenu->setItemEnabled( ID_EDIT_CUT, flag );
    _editmenu->setItemEnabled( ID_EDIT_COPY, flag );
    _editmenu->setItemEnabled( ID_EDIT_CLEAR, flag );
    _editmenu->setItemEnabled( ID_EDIT_TRANSPOSE, flag );
    _editmenu->setItemEnabled( ID_EDIT_QUANTIZE_ALL, flag );
    _editmenu->setItemEnabled( ID_EDIT_QUANTIZE_LENGTH, flag );
    _editmenu->setItemEnabled( ID_EDIT_FIXED_LENGTH, flag );
    break;
  case MEMORY:
    _toolbar->setItemEnabled( ID_EDIT_PASTE, flag );
    _editmenu->setItemEnabled( ID_EDIT_PASTE, flag );

    break;
  }
}

void KdeScoreEditor::print() {
  _content->print();
}

void KdeScoreEditor::settings() {
  _content->settings();
}

void KdeScoreEditor::slotMenu(int i) {
  // cout << i << endl;
  _toolbar->commandCallback(i);
}

void KdeScoreEditor::slotGridMenu(int i) {
  _gridmenu->setItemChecked(_grid_id,false);
  _grid_id = i;
  _gridmenu->setItemChecked(_grid_id,true);
  switch (i) {
  case ID_GRID_1: setGrid(1536); break;
  case ID_GRID_2: setGrid(768); break;
  case ID_GRID_4: setGrid(384); break;
  case ID_GRID_8: setGrid(192); break;
  case ID_GRID_16: setGrid(96); break;
  case ID_GRID_32: setGrid(48); break;
  case ID_GRID_64: setGrid(24); break;
  case ID_GRID_OFF: setGrid(0); break;
  }
}

void KdeScoreEditor::slotDynMenu(int i) {
  _dynamicsmenu->setItemChecked(_dyn_id,false);
  _dyn_id = i;
  _dynamicsmenu->setItemChecked(_dyn_id,true);
}

void KdeScoreEditor::slotViewMenu(int i) {
  bool ch = _viewmenu->isItemChecked(i);
  ch = !ch;
  _viewmenu->setItemChecked(i,ch);
  switch(i) {
  case ID_VIEW_TOOLBAR:
    if (ch) _toolbar->show(); else _toolbar->hide();
    break;
  case ID_VIEW_NOTEBAR:
    if (ch) _notebar->show(); else _notebar->hide();
    break;
  case ID_VIEW_BUTTONBAR:
    if (ch) _buttonbar->show(); else _buttonbar->hide();
    break;
  case ID_VIEW_SLIDER:
    if (ch) _scrollbar->show(); else _scrollbar->hide();
    break;
  }
}


void KdeScoreEditor::toolMenu(int i) {
  _toolmenu->setItemChecked(tool(),false);
  setTool(i);
  _toolmenu->setItemChecked(tool(),true);
  if (tool()==ID_TOOL_ANS)
    if (!showNEXT) optionsMenu(ID_OPTIONS_NEXT);
  if (tool()==ID_TOOL_AOS)
    if (!showAUX) optionsMenu(ID_OPTIONS_AUX);
}


void KdeScoreEditor::setTool(int i) {
  _tool = i;
  _content->updateCursor();
}

int KdeScoreEditor::tool() {
  return _tool;
}


void KdeScoreEditor::optionsMenu(int n) {
  switch(n) {
  case ID_OPTIONS_AUX:
    //if (showAUX) { showAUX = false; options->setItemChecked(ID_OPTIONS_AUX,false); scoreAux->hide(); }
    //else { showAUX = true; options->setItemChecked(ID_OPTIONS_AUX,true); scoreAux->show(); }
    break;
  case ID_OPTIONS_NEXT:
    //if (showNEXT) { showNEXT = false; options->setItemChecked(ID_OPTIONS_NEXT,false); noteExt->hide(); }
    //else { showNEXT = true; options->setItemChecked(ID_OPTIONS_NEXT,true); noteExt->show(); }
    break;
  case ID_OPTIONS_STN:
    if (showTN==TRUE) showTN=FALSE;
    else showTN=TRUE;
    _optionsmenu->setItemChecked(ID_OPTIONS_STN,showTN);
    _content->repaint(FALSE);
    break;
  case ID_OPTIONS_SIN:
    if (showIN==TRUE) showIN=FALSE;
    else showIN=TRUE;
    _optionsmenu->setItemChecked(ID_OPTIONS_SIN,showIN);
    _content->repaint(FALSE);
    break;
  case ID_OPTIONS_LYRICS:
    //if (showLYR==true) { showLYR=false; yAux = 0; volGrabX1 = 0; }
    //else { showLYR = true; showVOL = false; yAux = 20; volGrabX1 = 0; }
    //options->setItemChecked(ID_OPTIONS_LYRICS,showLYR);
    //options->setItemChecked(ID_OPTIONS_VOLUMES,showVOL);
    // TODO: setFixedHeight(parts*(100+yAux)+YTOP);
    break;
  case ID_OPTIONS_VOLUMES:
    //if (showVOL==true) { showVOL=false; yAux = 0; volGrabX1 = 0; }
    //else { showVOL = true; showLYR = false; yAux = 64; volGrabX1 = 0; }
    //options->setItemChecked(ID_OPTIONS_LYRICS,showLYR);
    //options->setItemChecked(ID_OPTIONS_VOLUMES,showVOL);
    // TODO:setFixedHeight(parts*(100+yAux)+YTOP);
    break;
  }
}

void KdeScoreEditor::keyPressEvent ( QKeyEvent * key ) {
  _content->keyPressEvent(key);
}

void KdeScoreEditor::keyReleaseEvent ( QKeyEvent * key ) {
  _content->keyReleaseEvent(key);
}

KdeScoreContent * KdeScoreEditor::content() { return _content; }

// *****************************************************************************
//
// PAINT EVENT
// ===========
//

void KdeScoreEditor::paintEvent( QPaintEvent * ) {
  //_content->repaint(FALSE);
  //_info->repaint(FALSE);

}

void KdeScoreEditor::setCursorPosition(long ticks) {
  _content->moveCursor(ticks);
}



#endif
#include "kdeScoreEditor.moc"
