#ifndef _KDESCOREEDITOR2_H_
#define _KDESCOREEDITOR2_H_

#include <kmainwindow.h>

#include "prScoreEditor.h"

class Track;
class Part;
class Note;
class Lyrics;
class ScoreGroup;
class QPopupMenu;
class QSplitter;
class QScrollView;
class QScrollBar;
class QWidget;
class QFrame;
class QPaintEvent;
class QPainter;
class QResizeEvent;
class KdeEditorToolBar;
class KdeEditorNoteBar;
class KdeEditorButtonBar;
class KdeEditorScrollBar;
class KdeEditInfo;
class KdeScoreContent2;

enum { ID_OPTIONS_TUPLETS_2, ID_OPTIONS_TUPLETS_3, ID_OPTIONS_TUPLETS_5, ID_OPTIONS_TUPLETS_7, ID_OPTIONS_TUPLETS_9, ID_OPTIONS_TUPLETS_11, ID_OPTIONS_TUPLETS_13, ID_OPTIONS_TUPLETS_15, ID_OPTIONS_TUPLETS_17, ID_OPTIONS_TUPLETS_19, ID_OPTIONS_TUPLETS_21 };


class KdeScoreEditor2 : public KMainWindow, public PrScoreEditor
{

  Q_OBJECT

 private:
  // QSplitter       * _splitter;
  QWidget         * _area;
  QScrollView     * _scroller;
  KdeEditorToolBar * _toolbar;
  KdeEditorNoteBar * _notebar;
  KdeEditorButtonBar * _buttonbar;
  KdeEditorScrollBar * _scrollbar;
  KdeScoreContent2 * _content;
  KdeEditInfo * _info;
  QPopupMenu      * _filemenu;
  QPopupMenu      * _editmenu;
  QPopupMenu      * _gridmenu;
  QPopupMenu      * _resmenu;
  QPopupMenu      * _dynamicsmenu;
  QPopupMenu      * _viewmenu;
  QPopupMenu      * _toolmenu;
  QPopupMenu      * _optionsmenu;
  QPopupMenu      * _tupletmenu;
  QPainter        * _score;
  int _xoffset;
  int _yoffset;
  int _ybottom;
  int _grid_id;
  int _res_id;
  int _dyn_id;
  int _tupl_id;
  bool _toolbarstate;
  bool _notebarstate;
  bool _buttonbarstate;
  bool _sliderstate;
  int _tool;
  bool showIN;
  bool showTN;
  bool showLYR;
  bool showVOL;
  bool showAUX;
  bool showNEXT;

 public:
  KdeScoreEditor2(QWidget * parent = 0);
  KdeScoreEditor2(Track*, QWidget * parent = 0);
  KdeScoreEditor2(Part*, QWidget * parent = 0);
  ~KdeScoreEditor2();

  QPainter * score();
  void setScore(QPainter*);

  virtual void update();
  virtual void gui(GuiEvents ev, bool flag);
  virtual void print();
  virtual void settings();
  virtual void setCursorPosition(long ticks);
  virtual int editorWidth() const;
  void run();

  bool showInstrumentName();
  bool showTrackName();
  KdeScoreContent2 * content();
  KdeEditInfo * info();
  int xoffset();

  // old:
  int gEnhValue();
  void sEnhValue(int e);
  void updateCursor();
  void setTool(int);
  int  tool();
  int  tuplid();
  void addMenuEntries();
  // void settings();

 public slots:
  // void paintEvent( QPaintEvent * );
  void resizeEvent( QResizeEvent * );
  void keyPressEvent ( QKeyEvent * );
  void keyReleaseEvent ( QKeyEvent * );
  void toolMenu(int);
  void optionsMenu(int);
  void tupletsMenu(int);

  void slotMenu( int );
  void slotGridMenu( int );
  void slotResMenu( int );
  void slotDynMenu( int );
  void slotViewMenu( int );
};

#endif
