/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/***************************************************************************
 *            gstreamer.h
 *
 *  Wed May 18 16:58:16 2005
 *  Copyright  2005  Philippe Rouquier
 *  <brasero-app@wanadoo.fr>
 ****************************************************************************/


#include <sys/types.h>
#include <unistd.h>

#include <glib.h>
#include <gtk/gtk.h>

#include <libgnomevfs/gnome-vfs.h>

#ifndef _UTILS_H
#define _UTILS_H

#ifdef __cplusplus
extern "C" {
#endif

#define BRASERO_STOCK_ICON "brasero-stock-icon"

#define BRASERO_ERROR brasero_error_quark()

typedef char *(*BraseroFormatTime) (double time,
				       gboolean with_unit,
				       gboolean round);

typedef enum {
	BRASERO_ERROR_NONE,
	BRASERO_ERROR_GENERAL
} BraSeroErrors;

void brasero_utils_init (void);

inline gboolean brasero_utils_is_gid_in_groups (gid_t gid);

GQuark brasero_error_quark (void);

char *brasero_utils_get_time_string (double time,
				     gboolean with_unit);

char *brasero_utils_get_time_string_from_size (double time,
					       gboolean with_unit,
					       gboolean round);

char *brasero_utils_get_size_string (double size,
				     gboolean with_unit,
				     gboolean round);

GdkPixbuf *brasero_utils_get_icon_for_mime (const char *mime, int size);
GdkPixbuf *brasero_utils_get_icon (const char *name, int size);

GtkWidget *brasero_utils_pack_properties (const char *title, ...);
GtkWidget *brasero_utils_pack_properties_list (const char *title, GSList *list);

GtkWidget *brasero_utils_make_button (char *text, char *stock);

gboolean brasero_utils_remove (const char *uri);

char *brasero_utils_escape_string (const char *text);

char *brasero_utils_check_for_parent_symlink (const char *uri);

gboolean brasero_utils_get_symlink_target (const char *uri,
					   GnomeVFSFileInfo *info,
					   GnomeVFSFileInfoOptions flags);

gboolean
brasero_utils_str_equal_64 (gconstpointer v1,
			    gconstpointer v2);

guint
brasero_utils_str_hash_64 (gconstpointer v);

void
brasero_utils_launch_app (GtkWidget *widget,
			  GSList *list);

void
brasero_utils_show_menu (int nb_selected,
			 GtkUIManager *manager,
			 GdkEventButton *event);
GtkWidget *
brasero_utils_get_use_info_notebook (void);

gchar *
brasero_utils_validate_uri (const gchar *uri, gboolean escaped);

#ifdef __cplusplus
}
#endif
#endif				/* _UTILS_H */
