// Brutal Chess
//
// File : boardmove.h
// Date : 05/03/2005
// Authors : Maxwell Lazaroff and Michael Cook
//
// Description : Keeps track of a move.

#ifndef __BOARDMOVE_H_IS_INCLUDED__
#define __BOARDMOVE_H_IS_INCLUDED__

#include <iostream>

class Board;

using namespace std;

typedef unsigned int uint;

class BoardMove {
 
 protected:

    uint 	_startx;
    uint 	_starty;
    uint 	_endx;
    uint 	_endy;
 	bool	_isEnPassant;
 	bool    _isCastling;
	
 public:
   
    //******** CONSTRUCTOR ********
    BoardMove(uint startx = 0, uint starty = 0, uint endx = 0, uint endy = 0);
   
	void setStart( uint startx, uint starty );
	void setStart( char sfile, uint srank );
	void setEnd( uint endx, uint endy );
	void setEnd( char efile, uint erank );
	
    //******** ACCESSORS ********
	char getStartFile() const { return 'a' + _starty; }
	uint getStartRank() const { return 8 - _startx; }
	char getEndFile() const { return 'a' + _endy; }
	uint getEndRank() const { return 8 - _endx; }
    uint getStartx() const;
    uint getStarty() const;
    uint getEndx() const;
    uint getEndy() const;

	void checkFlags( const Board & board );

	bool getIsEnPassant();
	void setIsEnPassant();
	void unsetIsEnPassant();

	void setStartx(uint sx) { _startx = sx; }
	void setStarty(uint sy) { _starty = sy; }
	void setEndx  (uint ex) { _endx   = ex; }
	void setEndy  (uint ey) { _endy   = ey; }
	
	bool getCastling();
    void setCastling();
    void unsetCastling();
    
};

inline istream&
operator>>(istream& in, BoardMove& move)
{
   uint startx, starty, endx, endy;
   in >> startx >> starty >> endx >> endy;
   move = BoardMove(startx, starty, endx, endy);
   return in;
}

inline ostream& 
operator<<(ostream& out, BoardMove& move)
{
   out << move.getStartFile() << move.getStartRank();
   out << " to " << move.getEndFile() << move.getEndRank();
   return out;
}

#endif // __BOARDMOVE_H_IS_INCLUDED__

// End of file boardmove.h
