/********************************************************************
 * Copyright (C) 2005 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BsC (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/

/*------- include files:
-------------------------------------------------------------------*/
#include "CmpFiles.h"
#include "Shared.h"
#include "Busy.h"
#include <qfile.h>
#include <cstring>
#include <cstdlib>
using namespace std;

//*******************************************************************
// compare                                                    PUBLIC
//*******************************************************************
CmpFiles::CmpResult CmpFiles::compare()
{
	CmpResult retval = IOError;
	
	QFile in1( d_name_1 );
	QFile in2( d_name_2 );
	
	Busy::set_busy( TRUE );
	//..............................................
	if( in1.open( IO_ReadOnly ) ) {
		if( in2.open( IO_ReadOnly ) ) {
			while( d_loop && ( FALSE == in1.atEnd() ) && ( FALSE == in2.atEnd() ) ){
				Shared::idle();
				const unsigned int n1 = in1.readBlock( d_buffer_1, BufferSize );
				const unsigned int n2 = in2.readBlock( d_buffer_2, BufferSize );
				retval = ( n1 == n2 ) ? compare_buffers( n1 ) : NotEqual;
				if( retval != Equal ) break;
			}
			in2.close();
		}
		in1.close();
	}
	//..............................................
	Busy::set_busy( FALSE );

	if( FALSE == d_loop ) retval = Break;			
	return retval;
}
// end of compare
