/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_COPIER_H
#define INCLUDED_COPIER_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_VIEWTABLE_H
#include "ViewTable.h"
#endif // INCLUDED_VIEWTABLE_H

#ifndef INCLUDED_QDIALOG_H
#include <qdialog.h>
#define INCLUDED_QDIALOG_H
#endif // INCLUDED_QDIALOG_H

#ifndef INCLUDED_QFILE_H
#include <qfile.h>
#define INCLUDED_QFILE_H
#endif // INCLUDED_QFILE_H

#ifndef INCLUDED_QFILEINFO_H
#include <qfileinfo.h>
#define INCLUDED_QFILEINFO_H
#endif // INCLUDED_QFILEINFO_H

#ifndef INCLUDED_QFONTMETRICS_H
#include <qfontmetrics.h>
#define INCLUDED_QFONTMETRICS_H
#endif // INCLUDED_QFONTMETRICS_H

#ifndef INCLUDED_VECTOR
#include <vector>
#define INCLUDED_VECTOR
#endif // INCLUDED_VECTOR

/*------- forward declarations:
-------------------------------------------------------------------*/
class InfoField;
class QPushButton;
class QProgressBar;
class QCheckBox;

/*------- class declaration:
-------------------------------------------------------------------*/
class Copier : public QDialog
{
	Q_OBJECT

// ******* CONSTRUCTION *******
public:
	Copier( QWidget* const in_parent, const ViewTable::SelectedItems& in_items, const QString& in_dst_dir );
private:
	Copier( const Copier& );
	Copier& operator=( const Copier& );

// ******* MEMBERS *******
private:
	enum { BufferSize = 8192 /*4096*/ };
	//....................................
	static const int     PROGRESS_MIN_SIZE;
	static const QString GBOX_INFO_TITEL;
	static const QString SRC_LABEL;
	static const QString DST_LABEL;
	static const QString GBOX_PROGRESS_LABEL;
	static const QString BTN_CONTINUE_LABEL;
	static const QString BTN_PAUSE_LABEL;
	static const QString NOT_WRITABLE_DIR;
	static const QString NOT_READABLE_FILE;
	static const QString MKDIR_ERROR;
	static const QString OPEN_FOR_READ_ERROR;
	static const QString OPEN_FOR_WRITE_ERROR;
	static const QString CB_REMOVE_LABEL;
	//....................................
	const ViewTable::SelectedItems& d_items;
	const QString&       d_dst_dir;
	
	QPushButton*  const  d_pause_button;
	QPushButton*  const  d_break_button;
	QCheckBox*    const  d_remove_cb;
	InfoField*           d_src_info;
	InfoField*           d_dst_info;
	QProgressBar*       	d_progress_bar;
	bool                 d_paused;
	bool                 d_started;
	bool                 d_stopped;
	int                  d_block_size;
	char                 d_buffer[BufferSize];
	bool                 d_ask_again;
	QFontMetrics         d_fm;

// ******* METHODS *******
private:
	QWidget* make_info_area     ();
	QWidget* make_progress_area ();
	QLayout* make_button_area   ();
	void		copy_next          ( const QFileInfo& in_fi, const QString& in_dst_dir );
	void		copy_subdir        ( const QString& in_src_dir, const QString& in_dst_dir );
	bool     can_copy           ( const QString& in_src, QString& in_dst );
	bool     can_update         ( const QString& in_src, const QString& in_dst );
	void     copy_file          ( const QString& in_src, const QString& in_dst );
	void     polish             ();
	void     display            ( const QString& in_src, const QString& in_dst );
	void     rename             ( QString& );
private slots:
	void     pause              ();
	void     finish             ();
	void     process            ();
signals:
	void     start              ();
};

#endif // INCLUDED_COPIER_H
