/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BSCommander is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BSCommander is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_DIRSDIALOG_H
#define INCLUDED_DIRSDIALOG_H
 
/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QDIALOG_H
#include <qdialog.h>
#define INCLUDED_QDIALOG_H
#endif // INCLUDED_QDIALOG_H

#ifndef INCLUDED_QLISTVIEW_H
#include <qlistview.h>
#define INCLUDED_QLISTVIEW_H
#endif // INCLUDED_QLISTVIEW_H

#ifndef INCLUDED_QHEADER_H
#include <qheader.h>
#define INCLUDED_QHEADER_H
#endif // INCLUDED_QHEADER_H

#ifndef INCLUDED_QDIR_H
#include <qdir.h>
#define INCLUDED_QDIR_H
#endif // INCLUDED_QDIR_H

#ifndef INCLUDED_QCHECKBOX_H
#include <qcheckbox.h>
#define INCLUDED_QCHECKBOX_H
#endif // INCLUDED_QCHECKBOX_H

#ifndef INCLUDED_MAP
#include <map>
#define INCLUDED_MAP
#endif // INCLUDED_MAP


/*------- forward declarations:
-------------------------------------------------------------------*/
class QHBoxLayout;
class QVBoxLayout;
class QPushButton;
class QGroupBox;
class QLabel;
class QListView;
class InfoField;

/*------- class declaration:
-------------------------------------------------------------------*/
class DirsDialog : public QDialog
{
	Q_OBJECT

// ******* DEFINITIONS *******
protected:
	typedef enum {
		Compare = 0,
		Synchronize
	} Operation;
private:
	enum { ColsNumber = 3 };
	typedef std::map<const QString, const QFileInfo* const , std::greater<const QString> > DataMap;
	class ViewItem : public QListViewItem
	{
		public:
			ViewItem(	QListView* const,
							const QString&, const QString&, const QString&,
							const QString&, const QString& );
		private:
			ViewItem( const ViewItem& );
			ViewItem& operator=( const ViewItem& );
		private:
			const QString d_lft_path;
			const QString d_rgt_path;
		private:
			int  compare  ( QListViewItem* in_item, int in_column, bool in_ascending ) const;
			void paintCell( QPainter*, const QColorGroup&, int, int, int );
		public:
			const QString& lft_path() const;
			const QString& rgt_path() const;
	};

// ******* CONSTRUCTION *******
public:
	DirsDialog( QWidget* const, const QString&, const QString&, const Operation );
private:
	DirsDialog( const DirsDialog& );
	DirsDialog& operator=( const DirsDialog& );

// ******* MEMBERS *******
private:
	static const QString Caption;
	static const QString InfoCaption;
	static const QString ResultCaption;
	static const QString LeftDirLabel;
	static const QString RightDirLabel;
	static const QString BlockLeftLabel;
	static const QString BlockRightLabel;
	static const QString OptionsLabel;
	static const QString ViewHdrCaption[ ColsNumber ];
	static const QString NotEqual;
protected:
	static const QString Equal;
	static const QString L2R;
	static const QString R2L;
	static const QString QuestMark;
	static const QString CopyMark;
	static const QString BlockMark;
	static const QString ErrorMark;
	static const QString DirMark;
	
	QHBoxLayout* const d_main_layout;
	QVBoxLayout* const d_wrk_layout;
	QGroupBox*   const d_info_grpbox;
	QLabel*      const d_src_dir_lbl;
	InfoField*   const d_src_dir_path;
	QLabel*      const d_dst_dir_lbl;
	InfoField*   const d_dst_dir_path;
	QGroupBox*   const d_blocks_grpbox;
	QGroupBox*   const d_result_grpbox;
	QListView*   const d_result_lv;
	QVBoxLayout* const d_btn_layout;
	QCheckBox*   const d_block_left;
	QCheckBox*   const d_block_right;
	const Operation    d_operation;

protected:
	const QString      d_src_dir;
	const QString      d_dst_dir;
	QPushButton* const d_run_btn;
	QPushButton* const d_close_btn;
	bool               d_break;
	bool               d_processing;

// ******* METHODS *******
protected:
	void set_info_title( const QString& );
	bool lft_is_blocked() const;
	bool rgt_is_blocked() const;
	void add_item      ( const QString&, const QString&, const QString&, const QString&, const QString& );
	void scanning      ( const QString&, const QString& );
private:
	void show          ();
	void polish        ();
	void keyPressEvent ( QKeyEvent* e );
	void adjust        ();
	void reset         ();
	void files         ( const QFileInfoList* const, DataMap& );
	void dirs          ( const QFileInfoList* const, DataMap& );
	void scan_files    ( const QFileInfoList* const, const QString&, const QFileInfoList* const, const QString& );
	void scan_dirs     ( const QFileInfoList* const, const QString&, const QFileInfoList* const, const QString& );
private slots:
	void toggled       ();
	void run_clicked   ();
	void close_clicked ();
signals:
	void file_do_it    ( const QString&, bool, bool, const QString&, const QString& );
	void dir_do_it     ( const QString&, bool, bool, const QString&, const QString& );
};

inline bool DirsDialog::lft_is_blocked() const { return d_block_left->isChecked(); }
inline bool DirsDialog::rgt_is_blocked() const { return d_block_right->isChecked(); }
inline const QString& DirsDialog::ViewItem::lft_path() const { return d_lft_path; }
inline const QString& DirsDialog::ViewItem::rgt_path() const { return d_rgt_path; }

#endif // INCLUDED_DIRSDIALOG_H
